/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntry;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultEntryGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchResultEntryGrammar.class);
    private static IGrammar instance = new SearchResultEntryGrammar();

    private SearchResultEntryGrammar() {
        this.name = SearchResultEntryGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_SEARCH_RESULT_ENTRY_STATE][256];
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_TAG][100] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_VALUE][100] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_TAG, new GrammarAction("Init SearchResultEntry"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new SearchResultEntry());
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_TAG, new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Name objectName = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength().getLength() == 0) {
                    searchResultEntry.setObjectName(objectName);
                } else {
                    try {
                        objectName = new LdapDN(tlv.getValue().getData());
                        objectName = LdapDN.normalize(objectName);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "The DN " + StringTools.dumpBytes(tlv.getValue().getData()) + "is invalid : " + ine.getMessage();
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        throw new DecoderException(msg, (Throwable)ine);
                    }
                    catch (NamingException ne) {
                        String msg = "The DN " + StringTools.dumpBytes(tlv.getValue().getData()) + "is invalid : " + ne.getMessage();
                        log.error("{} : {}", (Object)msg, (Object)ne.getMessage());
                        throw new DecoderException(msg, (Throwable)ne);
                    }
                    searchResultEntry.setObjectName(objectName);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Search Result Entry DN found : {}", (Object)searchResultEntry.getObjectName());
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_TAG][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_VALUE][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_TAG, new GrammarAction("Pop and end allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
                container.grammarEndAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_TAG][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE, new GrammarAction("Pop not allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(false);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_TAG, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_TAG, new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapString type = LdapString.EMPTY_STRING;
                if (tlv.getLength().getLength() == 0) {
                    searchResultEntry.addAttributeValues(type);
                } else {
                    try {
                        type = LdapDN.normalizeAttribute(tlv.getValue().getData());
                        searchResultEntry.addAttributeValues(type);
                    }
                    catch (LdapStringEncodingException lsee) {
                        log.error("Invalid attribute type : {}", (Object)StringTools.dumpBytes(tlv.getValue().getData()));
                        throw new DecoderException("The attribute type is invalid : " + lsee.getMessage());
                    }
                }
                log.debug("Attribute type : {}", (Object)type);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_TAG][49] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_VALUE][49] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG, new GrammarAction("Pop and end allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
                container.grammarEndAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG, new GrammarAction("Store Attribute Value value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Object value = null;
                if (tlv.getLength().getLength() == 0) {
                    searchResultEntry.addAttributeValue("");
                    log.debug("The attribute value is null");
                } else {
                    if (ldapMessageContainer.isBinary(searchResultEntry.getCurrentAttributeValueType())) {
                        value = tlv.getValue().getData();
                        if (log.isDebugEnabled()) {
                            log.debug("Attribute value {}", (Object)StringTools.dumpBytes(value));
                        }
                    } else {
                        value = StringTools.utf8ToString(tlv.getValue().getData());
                        log.debug("Attribute value {}", value);
                    }
                    searchResultEntry.addAttributeValue(value);
                }
                ldapMessageContainer.grammarEndAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

