/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.SynchronizedLRUMap;

public class CachingNormalizer
implements Normalizer {
    public static final int CACHE_MAX = 250;
    private final SynchronizedLRUMap cache;
    private final Normalizer normalizer;

    public CachingNormalizer(Normalizer normalizer) {
        this(normalizer, 250);
    }

    public CachingNormalizer(Normalizer normalizer, int cacheSz) {
        this.normalizer = normalizer;
        this.cache = new SynchronizedLRUMap(cacheSz);
    }

    public Object normalize(Object value) throws NamingException {
        if (value == null) {
            return null;
        }
        Object result = this.cache.get(value);
        if (result != null) {
            return result;
        }
        Object normalized = this.normalizer.normalize(value);
        this.cache.put(value, normalized);
        return normalized;
    }
}

