/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.message.AbstractResponse;
import org.apache.directory.shared.ldap.message.SearchResponseEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class SearchResponseEntryImpl
extends AbstractResponse
implements SearchResponseEntry {
    static final long serialVersionUID = -8357316233060886637L;
    private LdapDN objectName;
    private Attributes attributes;

    public SearchResponseEntryImpl(int id) {
        super(id, TYPE);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = AttributeUtils.toAttributesImpl(attributes);
    }

    public LdapDN getObjectName() {
        return this.objectName;
    }

    public void setObjectName(LdapDN objectName) {
        this.objectName = objectName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SearchResponseEntry resp = (SearchResponseEntry)obj;
        if (!this.objectName.equals(resp.getObjectName())) {
            return false;
        }
        if (this.attributes == null && resp.getAttributes() != null) {
            return false;
        }
        if (this.attributes != null && resp.getAttributes() == null) {
            return false;
        }
        if (this.attributes != null && resp.getAttributes() != null) {
            return this.attributes.equals(resp.getAttributes());
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Result Entry\n");
        sb.append("        Object Name : '").append(this.objectName.toString()).append("'\n");
        sb.append("        Attributes\n");
        if (this.attributes != null) {
            sb.append(AttributeUtils.toString(this.attributes));
        } else {
            sb.append("            No attributes\n");
        }
        return sb.toString();
    }
}

