/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.exception;

import javax.naming.ServiceUnavailableException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class LdapServiceUnavailableException
extends ServiceUnavailableException
implements LdapException {
    static final long serialVersionUID = -5058439476235675179L;
    private final ResultCodeEnum resultCode;

    public LdapServiceUnavailableException(ResultCodeEnum resultCode) {
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapServiceUnavailableException(String explanation, ResultCodeEnum resultCode) {
        super(explanation);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        if (!ResultCodeEnum.getServiceCodes().contains(resultCode)) {
            String msg = "Only the following LDAP result codes can be used: " + ResultCodeEnum.getSearchCodes();
            throw new IllegalArgumentException(msg);
        }
    }

    public final ResultCodeEnum getResultCode() {
        return this.resultCode;
    }
}

