/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Serializable;
import java.util.Arrays;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTypeAndValue
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger((Class)AttributeTypeAndValue.class);
    private String type;
    private Object value;
    private String upName;
    private int start;
    private int length;
    private static final boolean CASE_SENSITIVE = true;
    private static final boolean CASE_INSENSITIVE = false;

    public AttributeTypeAndValue() {
        this.type = null;
        this.value = null;
        this.upName = "";
        this.start = -1;
        this.length = 0;
    }

    public AttributeTypeAndValue(String type, Object value) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            log.error("The type cannot be empty or null");
            throw new InvalidNameException("Null or empty type is not allowed");
        }
        this.type = type.trim().toLowerCase();
        this.value = value instanceof String ? (StringTools.isEmpty((String)value) ? "" : value) : value;
        this.upName = type + '=' + value;
        this.start = 0;
        this.length = this.upName.length();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            log.error("The type cannot be empty or null");
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null or empty ");
        }
        this.type = type.trim().toLowerCase();
        this.upName = type + this.upName.substring(this.upName.indexOf(61));
        this.start = -1;
        this.length = this.upName.length();
    }

    public void setTypeNormalized(String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            log.error("The type cannot be empty or null");
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null or empty ");
        }
        this.type = type.trim().toLowerCase();
        this.upName = type + this.upName.substring(this.upName.indexOf(61));
        this.start = -1;
        this.length = this.upName.length();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value instanceof String ? (StringTools.isEmpty((String)value) ? "" : (String)value) : value;
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + value;
        this.start = -1;
        this.length = this.upName.length();
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public String getUpName() {
        return this.upName;
    }

    public void setValueNormalized(String value) {
        String newValue = StringTools.trim(value);
        this.value = StringTools.isEmpty(newValue) ? "" : newValue;
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + value;
        this.start = -1;
        this.length = this.upName.length();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.type, nc.type);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.value, nc.value, true);
        }
        return 1;
    }

    public int compareToIgnoreCase(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.type, nc.type);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.value, nc.value, false);
        }
        return 1;
    }

    private int compareType(String val1, String val2) {
        if (StringTools.isEmpty(val1)) {
            return StringTools.isEmpty(val2) ? 0 : -1;
        }
        if (StringTools.isEmpty(val2)) {
            return 1;
        }
        return StringTools.trim(val1).compareToIgnoreCase(StringTools.trim(val2));
    }

    private int compareValue(Object val1, Object val2, boolean sensitivity) {
        if (val1 instanceof String) {
            if (val2 instanceof String) {
                int val;
                int n = val = sensitivity ? ((String)val1).compareTo((String)val2) : ((String)val1).compareToIgnoreCase((String)val2);
                return val < 0 ? -1 : (val > 0 ? 1 : val);
            }
            return 1;
        }
        if (val1 instanceof byte[]) {
            if (Arrays.equals((byte[])val1, (byte[])val2)) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public String normalize() {
        if (this.value instanceof String) {
            return StringTools.lowerCase(StringTools.trim(this.type)) + '=' + StringTools.trim((String)this.value);
        }
        return StringTools.lowerCase(StringTools.trim(this.type)) + "=#" + StringTools.dumpHexPairs((byte[])this.value);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.type != null ? this.type.hashCode() : 0);
        result = result * 37 + (this.value != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (StringTools.isEmpty(this.type) || StringTools.isEmpty(this.type.trim())) {
            return "";
        }
        sb.append(this.type).append("=");
        if (this.value != null) {
            sb.append(this.value);
        }
        return sb.toString();
    }
}

