/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.search.AndFilter;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.OrFilter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)FilterGrammar.class);
    private static IGrammar instance = new FilterGrammar();

    private FilterGrammar() {
        this.name = FilterGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_FILTER_STATE][256];
        this.transitions[LdapStatesEnum.FILTER_TAG][160] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_AND_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][161] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_OR_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][162] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_NOT_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][163] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_EQUALITY_MATCH_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][164] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, 6400, new GrammarAction("Allow pop"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_TAG][165] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_GREATER_OR_EQUAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][166] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_LESS_OR_EQUAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][135] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_PRESENT_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][168] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_APPROX_MATCH_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][169] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, 6656, new GrammarAction("Allow pop"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_AND_VALUE][160] = new GrammarTransition(LdapStatesEnum.FILTER_AND_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init And Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The And filter PDU must not be empty");
                    throw new DecoderException("The And filter PDU must not be empty");
                }
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                AndFilter andFilter = new AndFilter();
                searchRequest.addCurrentFilter(andFilter);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_OR_VALUE][161] = new GrammarTransition(LdapStatesEnum.FILTER_OR_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init Or Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The Or filter PDU must not be empty");
                    throw new DecoderException("The Or filter PDU must not be empty");
                }
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                OrFilter orFilter = new OrFilter();
                searchRequest.addCurrentFilter(orFilter);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_NOT_VALUE][162] = new GrammarTransition(LdapStatesEnum.FILTER_NOT_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init Not Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The Not filter PDU must not be empty");
                    throw new DecoderException("The Not filter PDU must not be empty");
                }
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                NotFilter notFilter = new NotFilter();
                searchRequest.addCurrentFilter(notFilter);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_EQUALITY_MATCH_VALUE][163] = new GrammarTransition(LdapStatesEnum.FILTER_EQUALITY_MATCH_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init Equality Match Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.terminalFilterAction(container, 0);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_GREATER_OR_EQUAL_VALUE][165] = new GrammarTransition(LdapStatesEnum.FILTER_GREATER_OR_EQUAL_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init Greater Or Equal Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.terminalFilterAction(container, 1);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_LESS_OR_EQUAL_VALUE][166] = new GrammarTransition(LdapStatesEnum.FILTER_LESS_OR_EQUAL_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init Less Or Equal Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.terminalFilterAction(container, 2);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_APPROX_MATCH_VALUE][168] = new GrammarTransition(LdapStatesEnum.FILTER_APPROX_MATCH_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init ApproxMatch Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.terminalFilterAction(container, 3);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG][4] = new GrammarTransition(LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE][4] = new GrammarTransition(LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE, LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG, new GrammarAction("Init attributeDesc Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                AttributeValueAssertion assertion = new AttributeValueAssertion();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The attribute description is empty ");
                    throw new DecoderException("The type can't be null");
                }
                try {
                    LdapString type = new LdapString(tlv.getValue().getData());
                    assertion.setAttributeDesc(type);
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = StringTools.dumpBytes(tlv.getValue().getData());
                    log.error("The assertion value ({}) is invalid", (Object)msg);
                    throw new DecoderException("Invalid assertion value " + msg + ", : " + lsee.getMessage());
                }
                AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequest.getTerminalFilter();
                terminalFilter.setAssertion(assertion);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG, LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init AssertionValue Value"){

            public void action(IAsn1Container container) throws DecoderException {
                AttributeValueAssertionFilter terminalFilter;
                AttributeValueAssertion assertion;
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                byte[] assertionValue = StringTools.EMPTY_BYTES;
                if (tlv.getLength().getLength() != 0) {
                    assertionValue = tlv.getValue().getData();
                }
                if (ldapMessageContainer.isBinary((assertion = (terminalFilter = (AttributeValueAssertionFilter)searchRequest.getTerminalFilter()).getAssertion()).getAttributeDesc())) {
                    assertion.setAssertionValue(assertionValue);
                } else {
                    assertion.setAssertionValue(StringTools.utf8ToString(assertionValue));
                }
                searchRequest.unstackFilters(container);
                container.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG, LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_PRESENT_VALUE][135] = new GrammarTransition(LdapStatesEnum.FILTER_PRESENT_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init present filter Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                PresentFilter presentFilter = new PresentFilter();
                searchRequest.addCurrentFilter(presentFilter);
                searchRequest.setTerminalFilter(presentFilter);
                String value = StringTools.utf8ToString(tlv.getValue().getData());
                if (StringTools.isEmpty(value)) {
                    presentFilter.setAttributeDescription(LdapString.EMPTY_STRING);
                } else {
                    try {
                        LdapString type = new LdapString(tlv.getValue().getData());
                        presentFilter.setAttributeDescription(type);
                    }
                    catch (LdapStringEncodingException lsee) {
                        String msg = StringTools.dumpBytes(tlv.getValue().getData());
                        log.error("Present filter attribute description ({}) is invalid", (Object)msg);
                        throw new DecoderException("Invalid present filter attribute description " + msg + ", : " + lsee.getMessage());
                    }
                }
                searchRequest.unstackFilters(container);
                container.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }

    private void terminalFilterAction(IAsn1Container container, int filterType) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(filterType);
        searchRequest.addCurrentFilter(filter);
        searchRequest.setTerminalFilter(filter);
    }
}

