/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.util.Iterator;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponse;
import org.apache.directory.shared.ldap.codec.LdapResult;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.util.LdapResultEnum;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapResultGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)LdapResultGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new LdapResultGrammar();

    private LdapResultGrammar() {
        this.name = LdapResultGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_LDAP_RESULT_STATE][256];
        this.transitions[LdapStatesEnum.LDAP_RESULT_CODE_TAG][10] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_CODE_TAG, LdapStatesEnum.LDAP_RESULT_CODE_VALUE, null);
        this.transitions[LdapStatesEnum.LDAP_RESULT_CODE_VALUE][10] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_CODE_VALUE, LdapStatesEnum.LDAP_RESULT_MATCHED_DN_TAG, new GrammarAction("Store resultCode"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                LdapResponse response = ldapMessage.getLdapResponse();
                LdapResult ldapResult = new LdapResult();
                response.setLdapResult(ldapResult);
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int resultCode = 0;
                try {
                    resultCode = IntegerDecoder.parse((Value)value, (int)0, (int)90);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The result code " + StringTools.dumpBytes(value.getData()) + " is invalid : " + ide.getMessage() + ". The result code must be between (0 .. 90)");
                    throw new DecoderException(ide.getMessage());
                }
                switch (resultCode) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 36: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 71: {
                        ldapResult.setResultCode(resultCode);
                        break;
                    }
                    default: {
                        log.warn("The resultCode " + resultCode + " is unknown.");
                        ldapResult.setResultCode(80);
                    }
                }
                if (IS_DEBUG) {
                    log.debug("The result code is set to " + LdapResultEnum.errorCode(resultCode));
                }
            }
        });
        this.transitions[LdapStatesEnum.LDAP_RESULT_MATCHED_DN_TAG][4] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_MATCHED_DN_TAG, LdapStatesEnum.LDAP_RESULT_MATCHED_DN_VALUE, null);
        this.transitions[LdapStatesEnum.LDAP_RESULT_MATCHED_DN_VALUE][4] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_MATCHED_DN_VALUE, LdapStatesEnum.LDAP_RESULT_ERROR_MESSAGE_TAG, new GrammarAction("Store Ldap Result matched DN"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                LdapResponse response = ldapMessage.getLdapResponse();
                LdapResult ldapResult = response.getLdapResult();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    ldapResult.setMatchedDN(LdapDN.EMPTY_LDAPDN);
                } else if (ldapResult.getResultCode() == 32 || ldapResult.getResultCode() == 33 || ldapResult.getResultCode() == 34 || ldapResult.getResultCode() == 36) {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        ldapResult.setMatchedDN(new LdapDN(dnBytes));
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Incorrect DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        throw new DecoderException("Incorrect DN given : " + ine.getMessage());
                    }
                } else {
                    log.warn("The matched DN should not be set when the result code is one of NoSuchObject, AliasProblem, InvalidDNSyntax or AliasDreferencingProblem");
                    ldapResult.setMatchedDN(LdapDN.EMPTY_LDAPDN);
                }
                if (IS_DEBUG) {
                    log.debug("The matchedDN is " + ldapResult.getMatchedDN());
                }
            }
        });
        this.transitions[LdapStatesEnum.LDAP_RESULT_ERROR_MESSAGE_TAG][4] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_ERROR_MESSAGE_TAG, LdapStatesEnum.LDAP_RESULT_ERROR_MESSAGE_VALUE, null);
        this.transitions[LdapStatesEnum.LDAP_RESULT_ERROR_MESSAGE_VALUE][4] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_ERROR_MESSAGE_VALUE, LdapStatesEnum.LDAP_RESULT_REFERRAL_SEQUENCE_TAG, new GrammarAction("Store Ldap Result error message"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                LdapResponse response = ldapMessage.getLdapResponse();
                LdapResult ldapResult = response.getLdapResult();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    ldapResult.setErrorMessage(LdapString.EMPTY_STRING);
                } else {
                    try {
                        ldapResult.setErrorMessage(new LdapString(tlv.getValue().getData()));
                    }
                    catch (LdapStringEncodingException lsee) {
                        log.error("The Error Message is invalid : " + StringTools.dumpBytes(tlv.getValue().getData()));
                        ldapResult.setErrorMessage(LdapString.EMPTY_STRING);
                    }
                }
                ldapMessageContainer.grammarEndAllowed(true);
                container.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("The error message is : " + ldapResult.getErrorMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.LDAP_RESULT_REFERRAL_SEQUENCE_TAG][163] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_REFERRAL_SEQUENCE_TAG, LdapStatesEnum.LDAP_RESULT_REFERRAL_SEQUENCE_VALUE, null);
        this.transitions[LdapStatesEnum.LDAP_RESULT_REFERRAL_SEQUENCE_VALUE][163] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_REFERRAL_SEQUENCE_VALUE, LdapStatesEnum.LDAP_RESULT_REFERRAL_TAG, new GrammarAction("Pop not allowed"){

            public void action(IAsn1Container container) {
                container.grammarPopAllowed(false);
            }
        });
        this.transitions[LdapStatesEnum.LDAP_RESULT_REFERRAL_TAG][4] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_REFERRAL_TAG, LdapStatesEnum.LDAP_RESULT_REFERRAL_VALUE, null);
        this.transitions[LdapStatesEnum.LDAP_RESULT_REFERRAL_VALUE][4] = new GrammarTransition(LdapStatesEnum.LDAP_RESULT_REFERRAL_VALUE, LdapStatesEnum.LDAP_RESULT_REFERRAL_TAG, new GrammarAction("Store Ldap Result referral"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                LdapResponse response = ldapMessage.getLdapResponse();
                LdapResult ldapResult = response.getLdapResult();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    ldapResult.addReferral(LdapURL.EMPTY_URL);
                } else if (ldapResult.getResultCode() == 10) {
                    try {
                        ldapResult.addReferral(new LdapURL(tlv.getValue().getData()));
                    }
                    catch (LdapURLEncodingException luee) {
                        String badUrl = new String(tlv.getValue().getData());
                        log.error("The URL " + badUrl + " is not valid : " + luee.getMessage());
                        throw new DecoderException("Invalid URL : " + luee.getMessage());
                    }
                } else {
                    log.warn("The Referral error message is not allowed when havind an error code no equals to REFERRAL");
                    ldapResult.addReferral(LdapURL.EMPTY_URL);
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    Iterator urls = ldapResult.getReferrals().iterator();
                    StringBuffer sb = new StringBuffer();
                    boolean isFirst = true;
                    while (urls.hasNext()) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(urls.next());
                    }
                    log.debug("The referral error message is set to " + sb.toString());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

