/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.directory.shared.ldap.filter.BranchNormalizedVisitor;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.DerefAliasesEnum;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.ScopeEnum;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.SearchResponseDone;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;

public class SearchRequestImpl
extends AbstractAbandonableRequest
implements SearchRequest {
    static final long serialVersionUID = -5655881944020886218L;
    private String baseDn;
    private ExprNode filter;
    private ScopeEnum scope;
    private boolean typesOnly;
    private int sizeLimit;
    private int timeLimit;
    private DerefAliasesEnum derefAliases;
    private Collection attributes = new ArrayList();
    private SearchResponseDone response;

    public SearchRequestImpl(int id) {
        super(id, TYPE);
    }

    public Collection getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public String getBase() {
        return this.baseDn;
    }

    public void setBase(String base) {
        this.baseDn = base;
    }

    public DerefAliasesEnum getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(DerefAliasesEnum derefAliases) {
        this.derefAliases = derefAliases;
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }

    public MessageTypeEnum[] getResponseTypes() {
        return (MessageTypeEnum[])RESPONSE_TYPES.clone();
    }

    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int entriesMax) {
        this.sizeLimit = entriesMax;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int secondsMax) {
        this.timeLimit = secondsMax;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
    }

    public void removeAttribute(String attribute) {
        this.attributes.remove(attribute);
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new SearchResponseDoneImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SearchRequest req = (SearchRequest)obj;
        if (!req.getBase().equals(this.baseDn)) {
            return false;
        }
        if (req.getDerefAliases() != this.derefAliases) {
            return false;
        }
        if (req.getScope() != this.scope) {
            return false;
        }
        if (req.getSizeLimit() != this.sizeLimit) {
            return false;
        }
        if (req.getTimeLimit() != this.timeLimit) {
            return false;
        }
        if (req.getTypesOnly() != this.typesOnly) {
            return false;
        }
        if (req.getAttributes() == null && this.attributes != null && this.attributes.size() > 0) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes == null && req.getAttributes().size() > 0) {
            return false;
        }
        if (req.getAttributes() != null && this.attributes != null) {
            if (req.getAttributes().size() != this.attributes.size()) {
                return false;
            }
            Iterator list = this.attributes.iterator();
            while (list.hasNext()) {
                if (req.getAttributes().contains(list.next())) continue;
                return false;
            }
        }
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        req.getFilter().accept(visitor);
        this.filter.accept(visitor);
        StringBuffer buf = new StringBuffer();
        this.filter.printToBuffer(buf);
        String myFilterString = buf.toString();
        buf.setLength(0);
        req.getFilter().printToBuffer(buf);
        String reqFilterString = buf.toString();
        return myFilterString.equals(reqFilterString);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    SearchRequest\n");
        sb.append("        baseDn : '").append(this.baseDn).append("'\n");
        if (this.filter != null) {
            sb.append("        filter : '");
            this.filter.printToBuffer(sb);
            sb.append("'\n");
        }
        sb.append("        scope : ");
        switch (this.scope.getValue()) {
            case 0: {
                sb.append("base object");
                break;
            }
            case 1: {
                sb.append("single level");
                break;
            }
            case 2: {
                sb.append("whole subtree");
            }
        }
        sb.append('\n');
        sb.append("        typesOnly : ").append(this.typesOnly).append('\n');
        if (this.sizeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.sizeLimit);
        }
        sb.append('\n');
        sb.append("        Time Limit : ");
        if (this.timeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.timeLimit);
        }
        sb.append('\n');
        sb.append("        Deref Aliases : ");
        switch (this.derefAliases.getValue()) {
            case 0: {
                sb.append("never Deref Aliases");
                break;
            }
            case 1: {
                sb.append("deref In Searching");
                break;
            }
            case 2: {
                sb.append("deref Finding Base Obj");
                break;
            }
            case 3: {
                sb.append("deref Always");
            }
        }
        sb.append('\n');
        sb.append("        attributes : ");
        boolean isFirst = true;
        if (this.attributes != null) {
            Iterator it = this.attributes.iterator();
            while (it.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\'').append((String)it.next()).append('\'');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

