/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.message.ResultResponse;

public class ModifyDnRequestImpl
extends AbstractAbandonableRequest
implements ModifyDnRequest {
    static final long serialVersionUID = 1233507339633051696L;
    private String name;
    private String newRdn;
    private String newSuperior;
    private boolean deleteOldRdn = false;
    private ModifyDnResponse response;

    public ModifyDnRequestImpl(int id) {
        super(id, TYPE);
    }

    public boolean getDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public boolean isMove() {
        return this.newSuperior != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.newSuperior = newSuperior;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyDnResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyDnRequest req = (ModifyDnRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (this.deleteOldRdn != req.getDeleteOldRdn()) {
            return false;
        }
        if (this.newRdn != null && req.getNewRdn() == null) {
            return false;
        }
        if (this.newRdn == null && req.getNewRdn() != null) {
            return false;
        }
        if (this.newRdn != null && req.getNewRdn() != null && !this.newRdn.equals(req.getNewRdn())) {
            return false;
        }
        if (this.newSuperior != null && req.getNewSuperior() == null) {
            return false;
        }
        if (this.newSuperior == null && req.getNewSuperior() != null) {
            return false;
        }
        return this.newSuperior == null || req.getNewSuperior() == null || this.newSuperior.equals(req.getNewSuperior());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ModifyDN Response\n");
        sb.append("        Entry : '").append(this.name).append("'\n");
        sb.append("        New RDN : '").append(this.newRdn.toString()).append("'\n");
        sb.append("        Delete old RDN : ").append(this.deleteOldRdn).append("\n");
        if (this.newSuperior != null) {
            sb.append("        New superior : '").append(this.newSuperior.toString()).append("'\n");
        }
        return sb.toString();
    }
}

