/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.shared.ldap.name.DnOidContainer;
import org.apache.directory.shared.ldap.name.LdapDnParser;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class LdapDnNormalizer
implements Normalizer {
    private static DnOidContainer oidContainer = DnOidContainer.getInstance();

    public static void setOidContainer(DnOidContainer oidContainer) {
        LdapDnNormalizer.oidContainer = oidContainer;
    }

    public Object normalize(Object value) throws NamingException {
        if (value instanceof String) {
            return LdapDnNormalizer.normalize((String)value);
        }
        return LdapDnNormalizer.normalize((Name)value);
    }

    private static Name internalNormalize(Name name) throws InvalidNameException, NamingException {
        if (oidContainer == null) {
            return name;
        }
        if (name.size() != 0) {
            // empty if block
        }
        return name;
    }

    public static Object normalize(Name value) throws NamingException {
        if (value == null) {
            return null;
        }
        return LdapDnNormalizer.internalNormalize(value);
    }

    public static Object normalize(String value) throws NamingException {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return LdapDnNormalizer.internalNormalize(LdapDnParser.getNameParser().parse(value));
    }

    public String toString() {
        return "DNNormalizer";
    }
}

