/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtherMailboxSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(OtherMailboxSyntaxChecker.class);
    private static final long serialVersionUID = 1L;

    public OtherMailboxSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.39");
    }

    public boolean isValidSyntax(Object value) {
        String mailbox;
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar == -1) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        String mailboxType = strValue.substring(0, dollar);
        String string = mailbox = dollar < strValue.length() - 1 ? strValue.substring(dollar + 1) : "";
        if (mailbox.indexOf(36) != -1) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (!StringTools.isPrintableString(mailboxType)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        boolean result = StringTools.isIA5String(mailbox);
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

