/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitReferralsAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitReferralsAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitReferralsAction() {
        super("Init the referrals list");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        LdapResponseCodec response = ldapMessage.getLdapResponse();
        LdapResultCodec ldapResult = response.getLdapResult();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = "The Referrals must not be null";
            log.error(msg);
            throw new DecoderException(msg);
        }
        if (IS_DEBUG) {
            log.debug("Initialising a referrals list");
        }
        ldapResult.initReferrals();
    }
}

