/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.control.replication;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueControlCodec;
import org.apache.directory.shared.ldap.message.control.AbstractMutableControlImpl;
import org.apache.directory.shared.ldap.message.control.replication.SyncInfoValueControl;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationInfoEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncInfoValueSyncIdSetControl
extends AbstractMutableControlImpl
implements SyncInfoValueControl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncInfoValueSyncIdSetControl.class);
    private byte[] cookie;
    private boolean refreshDeletes = true;
    private List<byte[]> syncUUIDs = new ArrayList<byte[]>();

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public boolean isRefreshDeletes() {
        return this.refreshDeletes;
    }

    public void setRefreshDeletes(boolean refreshDeletes) {
        this.refreshDeletes = refreshDeletes;
    }

    public List<byte[]> getSyncUUIDs() {
        return this.syncUUIDs;
    }

    public void addSyncUUID(byte[] syncUUID) {
        this.syncUUIDs.add(syncUUID);
    }

    @Override
    public String getID() {
        return "1.3.6.1.4.1.4203.1.9.1.4";
    }

    @Override
    public byte[] getEncodedValue() {
        SyncInfoValueControlCodec syncInfoValueCtlCodec = new SyncInfoValueControlCodec(SynchronizationInfoEnum.SYNC_ID_SET);
        syncInfoValueCtlCodec.setCookie(this.cookie);
        try {
            return syncInfoValueCtlCodec.encode(null).array();
        }
        catch (EncoderException e) {
            LOG.error("Failed to encode syncInfoValue control", (Throwable)e);
            throw new IllegalStateException("Failed to encode control with encoder.", e);
        }
    }
}

