/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.search.controls.PagedSearchControlCodec;
import org.apache.directory.shared.ldap.codec.search.controls.PagedSearchControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.PagedSearchControlStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedSearchControlGrammar
extends AbstractGrammar {
    static final Logger log = LoggerFactory.getLogger(PagedSearchControlGrammar.class);
    static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new PagedSearchControlGrammar();

    private PagedSearchControlGrammar() {
        this.name = PagedSearchControlGrammar.class.getName();
        this.statesEnum = PagedSearchControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[8][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, (IAction)new GrammarAction("Init PagedSearchControl"){

            public void action(IAsn1Container container) {
                PagedSearchControlContainer pagedSearchContainer = (PagedSearchControlContainer)container;
                PagedSearchControlCodec control = new PagedSearchControlCodec();
                pagedSearchContainer.setPagedSearchControl(control);
            }
        });
        this.transitions[1][2] = new GrammarTransition(1, 3, 2, (IAction)new GrammarAction("Set PagedSearchControl size"){

            public void action(IAsn1Container container) throws DecoderException {
                PagedSearchControlContainer pagedSearchContainer = (PagedSearchControlContainer)container;
                Value value = pagedSearchContainer.getCurrentTLV().getValue();
                try {
                    int size = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    if (IS_DEBUG) {
                        log.debug("size = " + size);
                    }
                    pagedSearchContainer.getPagedSearchControl().setSize(size);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the size for PagedSearchControl";
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[3][4] = new GrammarTransition(3, 5, 4, (IAction)new GrammarAction("Set PagedSearchControl cookie"){

            public void action(IAsn1Container container) throws DecoderException {
                PagedSearchControlContainer pagedSearchContainer = (PagedSearchControlContainer)container;
                Value value = pagedSearchContainer.getCurrentTLV().getValue();
                if (pagedSearchContainer.getCurrentTLV().getLength() == 0) {
                    pagedSearchContainer.getPagedSearchControl().setCookie(StringTools.EMPTY_BYTES);
                } else {
                    pagedSearchContainer.getPagedSearchControl().setCookie(value.getData());
                }
                pagedSearchContainer.grammarEndAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

