/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapResponse;
import org.apache.directory.shared.ldap.util.StringTools;

public class BindResponse
extends LdapResponse {
    private byte[] serverSaslCreds;
    private int bindResponseLength;

    public int getMessageType() {
        return 4;
    }

    public byte[] getServerSaslCreds() {
        if (this.serverSaslCreds == null) {
            return null;
        }
        byte[] copy = new byte[this.serverSaslCreds.length];
        System.arraycopy(this.serverSaslCreds, 0, copy, 0, this.serverSaslCreds.length);
        return copy;
    }

    public void setServerSaslCreds(byte[] serverSaslCreds) {
        if (serverSaslCreds != null) {
            this.serverSaslCreds = new byte[serverSaslCreds.length];
            System.arraycopy(serverSaslCreds, 0, this.serverSaslCreds, 0, serverSaslCreds.length);
        } else {
            this.serverSaslCreds = null;
        }
    }

    public int computeLength() {
        int ldapResponseLength;
        this.bindResponseLength = ldapResponseLength = super.computeLength();
        if (this.serverSaslCreds != null) {
            this.bindResponseLength += 1 + TLV.getNbBytes((int)this.serverSaslCreds.length) + this.serverSaslCreds.length;
        }
        return 1 + TLV.getNbBytes((int)this.bindResponseLength) + this.bindResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)97);
            buffer.put(TLV.getBytes((int)this.bindResponseLength));
            super.encode(buffer);
            if (this.serverSaslCreds != null) {
                buffer.put((byte)-121);
                buffer.put(TLV.getBytes((int)this.serverSaslCreds.length));
                if (this.serverSaslCreds.length != 0) {
                    buffer.put(this.serverSaslCreds);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    BindResponse\n");
        sb.append(super.toString());
        if (this.serverSaslCreds != null) {
            sb.append("        Server sasl credentials : '").append(StringTools.dumpBytes(this.serverSaslCreds)).append("'\n");
        }
        return sb.toString();
    }
}

