/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.AntlrSubtreeSpecificationCheckerTokenTypes;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;
import org.apache.directory.shared.ldap.util.OptionalComponentsMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntlrSubtreeSpecificationChecker
extends LLkParser
implements AntlrSubtreeSpecificationCheckerTokenTypes {
    private static final Logger log = LoggerFactory.getLogger(AntlrSubtreeSpecificationChecker.class);
    private ComponentsMonitor subtreeSpecificationComponentsMonitor = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"end\"", "OPEN_CURLY", "SP", "SEP", "CLOSE_CURLY", "\"base\"", "\"specificExclusions\"", "\"chopBefore\"", "COLON", "\"chopAfter\"", "\"minimum\"", "\"maximum\"", "\"specificationFilter\"", "FILTER", "SAFEUTF8STRING", "INTEGER", "DESCR", "NUMERICOID", "\"item\"", "\"and\"", "\"or\"", "\"not\"", "INTEGER_OR_NUMERICOID", "DOT", "DIGIT", "LDIGIT", "ALPHA", "SAFEUTF8CHAR", "FILTER_VALUE"};

    public void init() {
    }

    private int token2Integer(Token token) throws RecognitionException {
        int i = 0;
        try {
            i = Integer.parseInt(token.getText());
        }
        catch (NumberFormatException e) {
            throw new RecognitionException("Value of INTEGER token " + token.getText() + " cannot be converted to an Integer");
        }
        return i;
    }

    protected AntlrSubtreeSpecificationChecker(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrSubtreeSpecificationChecker(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected AntlrSubtreeSpecificationChecker(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrSubtreeSpecificationChecker(TokenStream lexer) {
        this(lexer, 1);
    }

    public AntlrSubtreeSpecificationChecker(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
    }

    public final void wrapperEntryPoint() throws RecognitionException, TokenStreamException {
        log.debug("entered wrapperEntryPoint()");
        this.subtreeSpecification();
        this.match(4);
    }

    public final void subtreeSpecification() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        this.subtreeSpecificationComponentsMonitor = new OptionalComponentsMonitor(new String[]{"base", "specificExclusions", "minimum", "maximum", "specificationFilter"});
        this.match(5);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                this.subtreeSpecificationComponent();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 7) {
                    this.match(7);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.subtreeSpecificationComponent();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(8);
    }

    public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        try {
            switch (this.LA(1)) {
                case 9: {
                    this.ss_base();
                    this.subtreeSpecificationComponentsMonitor.useComponent("base");
                    break;
                }
                case 10: {
                    this.ss_specificExclusions();
                    this.subtreeSpecificationComponentsMonitor.useComponent("specificExclusions");
                    break;
                }
                case 14: {
                    this.ss_minimum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("minimum");
                    break;
                }
                case 15: {
                    this.ss_maximum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("maximum");
                    break;
                }
                case 16: {
                    this.ss_specificationFilter();
                    this.subtreeSpecificationComponentsMonitor.useComponent("specificationFilter");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void ss_base() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_base()");
        this.match(9);
        int _cnt1572 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1572 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1572;
        }
        this.distinguishedName();
    }

    public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_specificExclusions()");
        this.match(10);
        int _cnt1575 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1575 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1575;
        }
        this.specificExclusions();
    }

    public final void ss_minimum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_minimum()");
        this.match(14);
        int _cnt1601 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1601 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1601;
        }
        this.baseDistance();
    }

    public final void ss_maximum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_maximum()");
        this.match(15);
        int _cnt1604 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1604 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1604;
        }
        this.baseDistance();
    }

    public final void ss_specificationFilter() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_specificationFilter()");
        this.match(16);
        int _cnt1607 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1607 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1607;
        }
        switch (this.LA(1)) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.refinement();
                break;
            }
            case 17: {
                this.filter();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void distinguishedName() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered distinguishedName()");
        try {
            token = this.LT(1);
            this.match(18);
            new LdapDN(token.getText());
            log.debug("recognized a DistinguishedName: " + token.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("dnParser failed for " + token.getText() + " " + e.getMessage());
        }
    }

    public final void specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusions()");
        this.match(5);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 11: 
            case 13: {
                this.specificExclusion();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 7) {
                    this.match(7);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.specificExclusion();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(8);
    }

    public final void specificExclusion() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusion()");
        switch (this.LA(1)) {
            case 11: {
                this.chopBefore();
                break;
            }
            case 13: {
                this.chopAfter();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void chopBefore() throws RecognitionException, TokenStreamException {
        log.debug("entered chopBefore()");
        this.match(11);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.distinguishedName();
    }

    public final void chopAfter() throws RecognitionException, TokenStreamException {
        log.debug("entered chopAfter()");
        this.match(13);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.distinguishedName();
    }

    public final void baseDistance() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered baseDistance()");
        token = this.LT(1);
        this.match(19);
        this.token2Integer(token);
    }

    public final void refinement() throws RecognitionException, TokenStreamException {
        log.debug("entered refinement()");
        switch (this.LA(1)) {
            case 22: {
                this.item();
                break;
            }
            case 23: {
                this.and();
                break;
            }
            case 24: {
                this.or();
                break;
            }
            case 25: {
                this.not();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void filter() throws RecognitionException, TokenStreamException {
        Token filterToken = null;
        log.debug("entered filter()");
        try {
            filterToken = this.LT(1);
            this.match(17);
            FilterParser.parse(filterToken.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("filterParser failed. " + e.getMessage());
        }
    }

    public final void oid() throws RecognitionException, TokenStreamException {
        log.debug("entered oid()");
        Token token = null;
        token = this.LT(1);
        switch (this.LA(1)) {
            case 20: {
                this.match(20);
                break;
            }
            case 21: {
                this.match(21);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        log.debug("recognized an oid: " + token.getText());
    }

    public final void item() throws RecognitionException, TokenStreamException {
        log.debug("entered item()");
        this.match(22);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.oid();
    }

    public final void and() throws RecognitionException, TokenStreamException {
        log.debug("entered and()");
        this.match(23);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.refinements();
    }

    public final void or() throws RecognitionException, TokenStreamException {
        log.debug("entered or()");
        this.match(24);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.refinements();
    }

    public final void not() throws RecognitionException, TokenStreamException {
        log.debug("entered not()");
        this.match(25);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.refinements();
    }

    public final void refinements() throws RecognitionException, TokenStreamException {
        log.debug("entered refinements()");
        this.match(5);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.refinement();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 7) {
                    this.match(7);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.refinement();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(8);
    }
}

