/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.LeafNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNode
extends LeafNode {
    protected Value<?> value;
    public static final boolean EVAL_GREATER = true;
    public static final boolean EVAL_LESSER = false;

    protected SimpleNode(String attribute, Value<?> value, AssertionType assertionType) {
        super(attribute, assertionType);
        this.value = value;
    }

    public final Value<?> getValue() {
        return this.value;
    }

    public void setValue(Value<?> value) {
        this.value = value;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        if (this.getAttribute() == null || !"objectClass".equalsIgnoreCase(this.getAttribute())) {
            throw new UnsupportedOperationException("Invalid attribute " + this.getAttribute() + " for a refinement");
        }
        buf.append("item: ").append(this.value);
        return buf;
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.value == null ? 0 : this.value.hashCode());
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleNode)) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        SimpleNode otherNode = (SimpleNode)other;
        if (this.value == null) {
            return otherNode.value == null;
        }
        return this.value.equals(otherNode.value);
    }
}

