/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.DITStructureRule;
import org.apache.directory.shared.ldap.model.schema.SchemaObject;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.registries.DITStructureRuleRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.OidRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDITStructureRuleRegistry
extends DefaultSchemaObjectRegistry<DITStructureRule>
implements DITStructureRuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDITStructureRuleRegistry.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected Map<Integer, DITStructureRule> byRuleId = new HashMap<Integer, DITStructureRule>();

    public DefaultDITStructureRuleRegistry() {
        super(SchemaObjectType.DIT_STRUCTURE_RULE, new OidRegistry());
    }

    @Override
    public boolean contains(int ruleId) {
        return this.byRuleId.containsKey(ruleId);
    }

    @Override
    public Iterator<DITStructureRule> iterator() {
        return this.byRuleId.values().iterator();
    }

    @Override
    public Iterator<Integer> ruleIdIterator() {
        return this.byRuleId.keySet().iterator();
    }

    @Override
    public String getSchemaName(int ruleId) throws LdapException {
        DITStructureRule ditStructureRule = this.byRuleId.get(ruleId);
        if (ditStructureRule != null) {
            return ditStructureRule.getSchemaName();
        }
        String msg = I18n.err((I18n)I18n.ERR_04263, (Object[])new Object[]{ruleId});
        LOG.warn(msg);
        throw new LdapException(msg);
    }

    @Override
    public void register(DITStructureRule ditStructureRule) throws LdapException {
        int ruleId = ditStructureRule.getRuleId();
        if (this.byRuleId.containsKey(ruleId)) {
            String msg = I18n.err((I18n)I18n.ERR_04264, (Object[])new Object[]{ruleId});
            LOG.warn(msg);
            throw new LdapException(msg);
        }
        this.byRuleId.put(ruleId, ditStructureRule);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registered {} for OID {}", (Object)ditStructureRule, (Object)ruleId);
        }
    }

    @Override
    public DITStructureRule lookup(int ruleId) throws LdapException {
        DITStructureRule ditStructureRule = this.byRuleId.get(ruleId);
        if (ditStructureRule == null) {
            String msg = I18n.err((I18n)I18n.ERR_04265, (Object[])new Object[]{ruleId});
            LOG.debug(msg);
            throw new LdapException(msg);
        }
        if (DEBUG) {
            LOG.debug("Found {} with ruleId: {}", (Object)ditStructureRule, (Object)ruleId);
        }
        return ditStructureRule;
    }

    @Override
    public void unregister(int ruleId) throws LdapException {
        DITStructureRule ditStructureRule = this.byRuleId.remove(ruleId);
        if (DEBUG) {
            LOG.debug("Removed {} with ruleId {} from the registry", (Object)ditStructureRule, (Object)ruleId);
        }
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        if (schemaName == null) {
            return;
        }
        for (DITStructureRule ditStructureRule : this) {
            if (!schemaName.equalsIgnoreCase(ditStructureRule.getSchemaName())) continue;
            int ruleId = ditStructureRule.getRuleId();
            SchemaObject removed = this.byRuleId.remove(ruleId);
            if (!DEBUG) continue;
            LOG.debug("Removed {} with ruleId {} from the registry", (Object)removed, (Object)ruleId);
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        for (DITStructureRule ditStructureRule : this) {
            if (!originalSchemaName.equalsIgnoreCase(ditStructureRule.getSchemaName())) continue;
            ditStructureRule.setSchemaName(newSchemaName);
            if (!DEBUG) continue;
            LOG.debug("Renamed {} schemaName to {}", (Object)ditStructureRule, (Object)newSchemaName);
        }
    }

    @Override
    public DefaultDITStructureRuleRegistry copy() {
        DefaultDITStructureRuleRegistry copy = new DefaultDITStructureRuleRegistry();
        copy.copy(this);
        return copy;
    }
}

