/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.DITContentRule;
import org.apache.directory.shared.ldap.model.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DITContentRuleDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(DITContentRuleDescriptionSchemaParser.class);

    public synchronized DITContentRule parseDITContentRuleDescription(String ditContentRuleDescription) throws ParseException {
        LOG.debug("Parsing a DITContentRule : {}", (Object)ditContentRuleDescription);
        if (ditContentRuleDescription == null) {
            LOG.error(I18n.err((I18n)I18n.ERR_04230, (Object[])new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(ditContentRuleDescription);
        try {
            DITContentRule ditContentRule = this.parser.ditContentRuleDescription();
            DITContentRuleDescriptionSchemaParser.updateSchemaName(ditContentRule);
            return ditContentRule;
        }
        catch (RecognitionException re) {
            String msg = I18n.err((I18n)I18n.ERR_04231, (Object[])new Object[]{ditContentRuleDescription, re.getMessage(), re.getColumn()});
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err((I18n)I18n.ERR_04232, (Object[])new Object[]{ditContentRuleDescription, tse.getMessage()});
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public DITContentRule parse(String schemaDescription) throws ParseException {
        return this.parseDITContentRuleDescription(schemaDescription);
    }
}

