/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ava
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Ava.class);
    private String normType;
    private String upType;
    private Value<?> normValue;
    private Value<?> upValue;
    private String upName;
    private AttributeType attributeType;
    private SchemaManager schemaManager;
    private volatile int h;
    private static final boolean[] DN_ESCAPED_CHARS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public Ava() {
        this(null);
    }

    public Ava(SchemaManager schemaManager) {
        this.normType = null;
        this.upType = null;
        this.normValue = null;
        this.upValue = null;
        this.upName = "";
        this.schemaManager = schemaManager;
        this.attributeType = null;
    }

    public Ava(String upType, byte[] upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, byte[] upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new BinaryValue(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new BinaryValue(upValue));
    }

    public Ava(String upType, String upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new StringValue(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new StringValue(upValue));
    }

    private void createAva(SchemaManager schemaManager, String upType, Value<?> upValue) throws LdapInvalidDnException {
        this.normType = this.attributeType.getOid();
        this.upType = upType;
        try {
            MatchingRule equalityMatchingRule = this.attributeType.getEquality();
            this.normValue = equalityMatchingRule != null ? equalityMatchingRule.getNormalizer().normalize(upValue) : upValue;
        }
        catch (LdapException le) {
            String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
        }
        this.upValue = upValue;
        this.upName = this.upType + '=' + (this.upValue == null ? "" : this.upValue.getString());
        this.hashCode();
    }

    private void createAva(String upType, Value<?> upValue) throws LdapInvalidDnException {
        String upTypeTrimmed = Strings.trim((String)upType);
        String normTypeTrimmed = Strings.trim((String)this.normType);
        if (Strings.isEmpty((String)upTypeTrimmed)) {
            if (Strings.isEmpty((String)normTypeTrimmed)) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.upType = this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
        } else if (Strings.isEmpty((String)normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii((String)upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = upType;
        }
        this.normValue = upValue;
        this.upValue = upValue;
        this.upName = this.upType + '=' + (this.upValue == null ? "" : this.upValue.getString());
        this.hashCode();
    }

    Ava(SchemaManager schemaManager, String upType, String normType, Value<?> upValue, Value<?> normValue) throws LdapInvalidDnException {
        this.upType = upType;
        this.normType = normType;
        this.upValue = upValue;
        this.normValue = normValue;
        this.upName = this.upType + '=' + (this.upValue == null ? "" : this.upValue.getString());
        if (schemaManager != null) {
            this.apply(schemaManager);
        }
        this.hashCode();
    }

    Ava(String upType, String normType, Value<?> upValue, Value<?> normValue, String upName) throws LdapInvalidDnException {
        String upTypeTrimmed = Strings.trim((String)upType);
        String normTypeTrimmed = Strings.trim((String)normType);
        if (Strings.isEmpty((String)upTypeTrimmed)) {
            if (Strings.isEmpty((String)normTypeTrimmed)) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = normType;
        } else if (Strings.isEmpty((String)normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii((String)upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii((String)normTypeTrimmed);
            this.upType = upType;
        }
        this.normValue = normValue;
        this.upValue = upValue;
        this.upName = upName;
        this.hashCode();
    }

    public void apply(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(this.upType);
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            this.normType = this.attributeType.getOid();
            try {
                MatchingRule equalityMatchingRule = this.attributeType.getEquality();
                this.normValue = equalityMatchingRule != null ? equalityMatchingRule.getNormalizer().normalize(this.upValue) : this.upValue;
            }
            catch (LdapException le) {
                String message = I18n.err((I18n)I18n.ERR_04188, (Object[])new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            this.hashCode();
        }
    }

    public String getNormType() {
        return this.normType;
    }

    public String getUpType() {
        return this.upType;
    }

    public Value<?> getNormValue() {
        return this.normValue.clone();
    }

    public Value<?> getUpValue() {
        return this.upValue.clone();
    }

    public String getNormName() {
        return this.normalize();
    }

    public String getUpName() {
        return this.upName;
    }

    public Ava clone() {
        try {
            Ava clone = (Ava)super.clone();
            clone.upValue = this.upValue.clone();
            clone.normValue = this.normValue.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    private String normalizeValue() {
        StringBuilder sb = new StringBuilder();
        String normalizedValue = this.normValue.getString();
        int valueLength = normalizedValue.length();
        if (normalizedValue.length() > 0) {
            char[] chars = normalizedValue.toCharArray();
            for (int i = 0; i < valueLength; ++i) {
                char c = chars[i];
                if (c >= '\u0000' && c < DN_ESCAPED_CHARS.length && DN_ESCAPED_CHARS[c]) {
                    switch (c) {
                        case ' ': {
                            if (i == 0 || i == valueLength - 1) {
                                sb.append("\\ ");
                                break;
                            }
                            sb.append(' ');
                            break;
                        }
                        case '#': {
                            if (i == 0) {
                                sb.append("\\#");
                                break;
                            }
                            sb.append('#');
                            break;
                        }
                        default: {
                            sb.append('\\').append(c);
                            break;
                        }
                    }
                    continue;
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public String normalize() {
        if (this.normValue.isHumanReadable()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.normType).append('=');
            String normalizedValue = this.normValue.getString();
            if (normalizedValue.length() > 0) {
                sb.append(this.normalizeValue());
            }
            return sb.toString();
        }
        return this.normType + "=#" + Strings.dumpHexPairs((byte[])this.normValue.getBytes());
    }

    public int hashCode() {
        if (this.h == 0) {
            this.h = 37;
            this.h = this.h * 17 + (this.normType != null ? this.normType.hashCode() : 0);
            this.h = this.h * 17 + (this.normValue != null ? this.normValue.hashCode() : 0);
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ava)) {
            return false;
        }
        Ava instance = (Ava)obj;
        if (this.normType == null ? instance.normType != null : !this.normType.equals(instance.normType)) {
            return false;
        }
        if (this.normValue.isNull()) {
            return instance.normValue.isNull();
        }
        if (this.schemaManager != null) {
            MatchingRule equalityMatchingRule = this.attributeType.getEquality();
            if (equalityMatchingRule != null) {
                return equalityMatchingRule.getLdapComparator().compare(this.normValue.getValue(), instance.normValue.getValue()) == 0;
            }
            return false;
        }
        return this.normValue.equals(instance.normValue);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (Strings.isEmpty((String)this.upName) || Strings.isEmpty((String)this.upType) || Strings.isEmpty((String)this.normType) || this.upValue.isNull() || this.normValue.isNull()) {
            String message = "Cannot serialize an wrong ATAV, ";
            if (Strings.isEmpty((String)this.upName)) {
                message = message + "the upName should not be null or empty";
            } else if (Strings.isEmpty((String)this.upType)) {
                message = message + "the upType should not be null or empty";
            } else if (Strings.isEmpty((String)this.normType)) {
                message = message + "the normType should not be null or empty";
            } else if (this.upValue.isNull()) {
                message = message + "the upValue should not be null";
            } else if (this.normValue.isNull()) {
                message = message + "the value should not be null";
            }
            LOG.error(message);
            throw new IOException(message);
        }
        if (this.upName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upName);
        } else {
            out.writeBoolean(false);
        }
        if (this.upType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upType);
        } else {
            out.writeBoolean(false);
        }
        if (this.normType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.normType);
        } else {
            out.writeBoolean(false);
        }
        boolean isHR = this.normValue.isHumanReadable();
        out.writeBoolean(isHR);
        this.upValue.writeExternal(out);
        this.normValue.writeExternal(out);
        out.writeInt(this.h);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isHR;
        boolean hasNormType;
        boolean hasUpType;
        boolean hasUpName = in.readBoolean();
        if (hasUpName) {
            this.upName = in.readUTF();
        }
        if (hasUpType = in.readBoolean()) {
            this.upType = in.readUTF();
        }
        if (hasNormType = in.readBoolean()) {
            this.normType = in.readUTF();
        }
        if (this.schemaManager != null) {
            this.attributeType = !Strings.isEmpty((String)this.upType) ? this.schemaManager.getAttributeType(this.upType) : this.schemaManager.getAttributeType(this.normType);
        }
        if (isHR = in.readBoolean()) {
            this.upValue = StringValue.deserialize(this.attributeType, in);
            this.normValue = StringValue.deserialize(this.attributeType, in);
        } else {
            this.upValue = BinaryValue.deserialize(this.attributeType, in);
            this.normValue = BinaryValue.deserialize(this.attributeType, in);
        }
        this.h = in.readInt();
        if (this.schemaManager != null) {
            this.attributeType = this.schemaManager.getAttributeType(this.upType);
        }
    }

    public boolean isSchemaAware() {
        return this.attributeType != null;
    }

    public String toString() {
        return this.upName;
    }
}

