/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.GracefulShutdownResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;

public class GracefulShutdownResponseImpl
extends ExtendedResponseImpl
implements GracefulShutdownResponse {
    private static final long serialVersionUID = -3824715470944544189L;

    public GracefulShutdownResponseImpl(int messageId, ResultCodeEnum rcode) {
        super(messageId, "1.3.6.1.4.1.18060.0.1.3");
        switch (rcode) {
            case SUCCESS: {
                break;
            }
            case OPERATIONS_ERROR: {
                break;
            }
            case INSUFFICIENT_ACCESS_RIGHTS: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04166, (Object[])new Object[]{ResultCodeEnum.SUCCESS, ResultCodeEnum.OPERATIONS_ERROR, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS}));
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public GracefulShutdownResponseImpl(int messageId) {
        super(messageId, "1.3.6.1.4.1.18060.0.1.3");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public GracefulShutdownResponseImpl() {
        super("1.3.6.1.4.1.18060.0.1.3");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public String getResponseName() {
        return "1.3.6.1.4.1.18060.0.1.3";
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04168, (Object[])new Object[]{"1.3.6.1.4.1.18060.0.1.3"}));
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.getClass().getName().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof GracefulShutdownResponseImpl;
    }
}

