/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.codec.stateful;

import java.util.LinkedList;
import org.apache.directory.shared.asn1.codec.stateful.DecoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.EncoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;

public class CallbackHistory
implements DecoderCallback,
EncoderCallback {
    private final LinkedList history;
    private final int length;

    public CallbackHistory() {
        this(-1);
    }

    public CallbackHistory(int length) {
        this.length = length;
        this.history = new LinkedList();
    }

    public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
        if (this.length > 0) {
            while (this.history.size() >= this.length) {
                this.history.removeLast();
            }
        }
        this.history.addFirst(decoded);
    }

    public void encodeOccurred(StatefulEncoder encoder, Object encoded) {
        if (this.length > 0) {
            while (this.history.size() >= this.length) {
                this.history.removeLast();
            }
        }
        this.history.addFirst(encoded);
    }

    public Object getMostRecent() {
        return this.history.getFirst();
    }

    public Object getOldest() {
        return this.history.getLast();
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public void clear() {
        this.history.clear();
    }

    public int size() {
        return this.history.size();
    }
}

