/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.normalizers;

import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanNormalizer
extends Normalizer {
    public BooleanNormalizer() {
        super("2.5.13.13");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapInvalidDnException {
        if (value == null) {
            return null;
        }
        String strValue = value.getString();
        return new StringValue(strValue.trim().toUpperCase());
    }

    @Override
    public String normalize(String value) throws LdapInvalidDnException {
        if (value == null) {
            return null;
        }
        return value.trim().toUpperCase();
    }
}

