/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddRequestImpl;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRequestDsml
extends AbstractResultResponseRequestDsml<AddRequest, AddResponse>
implements AddRequest {
    private Attribute currentAttribute;

    public AddRequestDsml(LdapApiService codec) {
        super(codec, new AddRequestImpl());
    }

    public AddRequestDsml(LdapApiService codec, AddRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    public void addAttributeType(String type) throws LdapException {
        if (((AddRequest)this.getDecorated()).getEntry().get(type) != null) {
            this.currentAttribute = ((AddRequest)this.getDecorated()).getEntry().get(type);
            return;
        }
        this.currentAttribute = new DefaultAttribute(type);
        ((AddRequest)this.getDecorated()).getEntry().put(this.currentAttribute);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public void addAttributeValue(String value) throws LdapException {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(Value<?> value) throws LdapException {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(byte[] value) throws LdapException {
        this.currentAttribute.add(new byte[][]{value});
    }

    @Override
    public MessageTypeEnum getType() {
        return ((AddRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Entry entry;
        Element element = super.toDsml(root);
        if (((AddRequest)this.getDecorated()).getEntry() != null) {
            element.addAttribute("dn", ((AddRequest)this.getDecorated()).getEntry().getDn().getName());
        }
        if ((entry = ((AddRequest)this.getDecorated()).getEntry()) != null) {
            for (Attribute attribute : entry) {
                Element attributeElement = element.addElement("attr");
                attributeElement.addAttribute("name", attribute.getId());
                for (Value value : attribute) {
                    if (ParserUtils.needsBase64Encoding(value.getValue())) {
                        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                        attributeElement.getDocument().getRootElement().add(xsdNamespace);
                        attributeElement.getDocument().getRootElement().add(xsiNamespace);
                        Element valueElement = attributeElement.addElement("value").addText(ParserUtils.base64Encode(value.getValue()));
                        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                        continue;
                    }
                    attributeElement.addElement("value").addText(value.getString());
                }
            }
        }
        return element;
    }

    public void initEntry() {
    }

    @Override
    public Entry getEntry() {
        return ((AddRequest)this.getDecorated()).getEntry();
    }

    public void addAttributeValue(Object value) throws LdapException {
        if (value instanceof Value) {
            ((AddRequestDsml)this.getDecorated()).addAttributeValue((Value)value);
        } else if (value instanceof String) {
            ((AddRequestDsml)this.getDecorated()).addAttributeValue((String)value);
        } else if (value instanceof byte[]) {
            ((AddRequestDsml)this.getDecorated()).addAttributeValue((byte[])value);
        }
    }

    @Override
    public Dn getEntryDn() {
        return ((AddRequest)this.getDecorated()).getEntryDn();
    }

    @Override
    public AddRequest setEntryDn(Dn entryDn) {
        ((AddRequest)this.getDecorated()).setEntryDn(entryDn);
        return this;
    }

    @Override
    public AddRequest setEntry(Entry entry) {
        ((AddRequest)this.getDecorated()).setEntry(entry);
        return this;
    }

    @Override
    public AddRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AddRequest addControl(Control control) throws MessageException {
        return (AddRequest)super.addControl(control);
    }

    @Override
    public AddRequest addAllControls(Control[] controls) throws MessageException {
        return (AddRequest)super.addAllControls(controls);
    }

    @Override
    public AddRequest removeControl(Control control) throws MessageException {
        return (AddRequest)super.removeControl(control);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return ((AddRequest)this.getDecorated()).getResponseType();
    }
}

