/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.utils;

import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesFactory {
    public ServerEntry getAttributes(SchemaObject obj, Schema schema, SchemaManager schemaManager) throws NamingException {
        if (obj instanceof LdapSyntax) {
            return this.getAttributes((LdapSyntax)obj, schema, schemaManager);
        }
        if (obj instanceof MatchingRule) {
            return this.getAttributes((MatchingRule)obj, schema, schemaManager);
        }
        if (obj instanceof AttributeType) {
            return this.getAttributes((AttributeType)obj, schema, schemaManager);
        }
        if (obj instanceof ObjectClass) {
            return this.getAttributes((ObjectClass)obj, schema, schemaManager);
        }
        if (obj instanceof MatchingRuleUse) {
            return this.getAttributes((MatchingRuleUse)obj, schema, schemaManager);
        }
        if (obj instanceof DITStructureRule) {
            return this.getAttributes((DITStructureRule)obj, schema, schemaManager);
        }
        if (obj instanceof DITContentRule) {
            return this.getAttributes((DITContentRule)obj, schema, schemaManager);
        }
        if (obj instanceof NameForm) {
            return this.getAttributes((NameForm)obj, schema, schemaManager);
        }
        throw new IllegalArgumentException(I18n.err((String)I18n.ERR_698, (Object[])new Object[]{obj.getClass()}));
    }

    public ServerEntry getAttributes(Schema schema, SchemaManager schemaManager) throws NamingException {
        String[] dependencies;
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaSchema"});
        entry.put("cn", new String[]{schema.getSchemaName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        if (schema.isDisabled()) {
            entry.put("m-disabled", new String[]{"TRUE"});
        }
        if ((dependencies = schema.getDependencies()) != null && dependencies.length > 0) {
            DefaultServerAttribute attr = new DefaultServerAttribute(schemaManager.lookupAttributeTypeRegistry("m-dependencies"));
            for (String dependency : dependencies) {
                attr.add(new String[]{dependency});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        return entry;
    }

    public ServerEntry getAttributes(SyntaxChecker syntaxChecker, Schema schema, SchemaManager schemaManager) {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaSyntaxChecker"});
        entry.put("m-oid", new String[]{syntaxChecker.getOid()});
        entry.put("m-fqcn", new String[]{syntaxChecker.getClass().getName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(LdapSyntax syntax, Schema schema, SchemaManager schemaManager) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaSyntax"});
        entry.put("x-humanReadable", new String[]{this.getBoolean(syntax.isHumanReadable())});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)syntax, (ServerEntry)entry, schemaManager);
        return entry;
    }

    public ServerEntry getAttributes(String oid, Normalizer normalizer, Schema schema, SchemaManager schemaManager) {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaNormalizer"});
        entry.put("m-oid", new String[]{oid});
        entry.put("m-fqcn", new String[]{normalizer.getClass().getName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(String oid, LdapComparator<? super Object> comparator, Schema schema, SchemaManager schemaManager) {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaComparator"});
        entry.put("m-oid", new String[]{oid});
        entry.put("m-fqcn", new String[]{comparator.getClass().getName()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(MatchingRule matchingRule, Schema schema, SchemaManager schemaManager) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaMatchingRule"});
        entry.put("m-syntax", new String[]{matchingRule.getSyntaxOid()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)matchingRule, (ServerEntry)entry, schemaManager);
        return entry;
    }

    public ServerEntry getAttributes(MatchingRuleUse matchingRuleUse, Schema schema, SchemaManager schemaManager) {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(DITStructureRule dITStructureRule, Schema schema, SchemaManager schemaManager) {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(DITContentRule dITContentRule, Schema schema, SchemaManager schemaManager) {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(NameForm nameForm, Schema schema, SchemaManager schemaManager) {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", ""});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        return entry;
    }

    public ServerEntry getAttributes(AttributeType attributeType, Schema schema, SchemaManager schemaManager) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaAttributeType"});
        entry.put("m-syntax", new String[]{attributeType.getSyntaxOid()});
        entry.put("m-collective", new String[]{this.getBoolean(attributeType.isCollective())});
        entry.put("m-noUserModification", new String[]{this.getBoolean(!attributeType.isUserModifiable())});
        entry.put("m-singleValue", new String[]{this.getBoolean(attributeType.isSingleValued())});
        entry.put("m-usage", new String[]{attributeType.getUsage().toString()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)attributeType, (ServerEntry)entry, schemaManager);
        String superiorOid = attributeType.getSuperiorOid();
        if (superiorOid != null) {
            entry.put("m-supAttributeType", new String[]{superiorOid});
        }
        if (attributeType.getEqualityOid() != null) {
            entry.put("m-equality", new String[]{attributeType.getEqualityOid()});
        }
        if (attributeType.getSubstringOid() != null) {
            entry.put("m-substr", new String[]{attributeType.getSubstringOid()});
        }
        if (attributeType.getOrderingOid() != null) {
            entry.put("m-ordering", new String[]{attributeType.getOrderingOid()});
        }
        return entry;
    }

    public ServerEntry getAttributes(ObjectClass objectClass, Schema schema, SchemaManager schemaManager) throws NamingException {
        DefaultServerAttribute attr;
        DefaultServerEntry entry = new DefaultServerEntry(schemaManager);
        entry.put("objectClass", new String[]{"top", "metaObjectClass"});
        entry.put("m-typeObjectClass", new String[]{objectClass.getType().toString()});
        entry.put("creatorsName", new String[]{schema.getOwner()});
        entry.put("createTimestamp", new String[]{DateUtils.getGeneralizedTime()});
        this.injectCommon((SchemaObject)objectClass, (ServerEntry)entry, schemaManager);
        if (objectClass.getSuperiorOids() != null && objectClass.getSuperiorOids().size() != 0) {
            attr = new DefaultServerAttribute(schemaManager.lookupAttributeTypeRegistry("m-supObjectClass"));
            for (String superior : objectClass.getSuperiorOids()) {
                attr.add(new String[]{superior});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        if (objectClass.getMustAttributeTypeOids() != null && objectClass.getMustAttributeTypeOids().size() != 0) {
            attr = new DefaultServerAttribute(schemaManager.lookupAttributeTypeRegistry("m-must"));
            for (String mustOid : objectClass.getMustAttributeTypeOids()) {
                attr.add(new String[]{mustOid});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        if (objectClass.getMayAttributeTypeOids() != null && objectClass.getMayAttributeTypeOids().size() != 0) {
            attr = new DefaultServerAttribute(schemaManager.lookupAttributeTypeRegistry("m-may"));
            for (String mayOid : objectClass.getMayAttributeTypeOids()) {
                attr.add(new String[]{mayOid});
            }
            entry.put(new EntryAttribute[]{attr});
        }
        return entry;
    }

    private final void injectCommon(SchemaObject object, ServerEntry entry, SchemaManager schemaManager) throws NamingException {
        this.injectNames(object.getNames(), entry, schemaManager);
        entry.put("m-obsolete", new String[]{this.getBoolean(object.isObsolete())});
        entry.put("m-oid", new String[]{object.getOid()});
        if (object.getDescription() != null) {
            entry.put("m-description", new String[]{object.getDescription()});
        }
    }

    private final void injectNames(List<String> names, ServerEntry entry, SchemaManager schemaManager) throws NamingException {
        if (names == null || names.size() == 0) {
            return;
        }
        DefaultServerAttribute attr = new DefaultServerAttribute(schemaManager.lookupAttributeTypeRegistry("m-name"));
        for (String name : names) {
            attr.add(new String[]{name});
        }
        entry.put(new EntryAttribute[]{attr});
    }

    private final String getBoolean(boolean value) {
        if (value) {
            return "TRUE";
        }
        return "FALSE";
    }
}

