/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ.state;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.state.NonExistentState;
import org.apache.directory.server.integ.state.StartedNormalState;
import org.apache.directory.server.integ.state.StartedPristineState;
import org.apache.directory.server.integ.state.TestServerState;
import org.apache.directory.server.ldap.LdapService;
import org.junit.internal.runners.MethodRoadie;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServerContext {
    private static final Logger LOG = LoggerFactory.getLogger(TestServerContext.class);
    private static final ThreadLocal<TestServerContext> CONTEXTS = new ThreadLocal();
    private final TestServerState nonExistentState = new NonExistentState(this);
    private final TestServerState startedPristineState = new StartedPristineState(this);
    private final TestServerState startedNormalState = new StartedNormalState(this);
    private TestServerState state = this.nonExistentState;
    private LdapService ldapService;

    private TestServerContext() {
    }

    public static TestServerContext get() {
        TestServerContext context = CONTEXTS.get();
        if (context == null) {
            context = new TestServerContext();
            CONTEXTS.set(context);
        }
        return context;
    }

    public static void set(TestServerContext context) {
        CONTEXTS.set(context);
    }

    public static void create(InheritableServerSettings settings) throws NamingException {
        TestServerContext.get().state.create(settings);
    }

    public static void destroy() {
        TestServerContext.get().state.destroy();
    }

    public static void cleanup() throws IOException {
        TestServerContext.get().state.cleanup();
    }

    public static void startup() throws Exception {
        TestServerContext.get().state.startup();
    }

    public static void shutdown() throws Exception {
        TestServerContext.get().state.shutdown();
    }

    public static void test(TestClass testClass, TestMethod testMethod, RunNotifier notifier, InheritableServerSettings settings) {
        LOG.debug("calling test(): {}", (Object)settings.getDescription().getDisplayName());
        TestServerContext.get().getState().test(testClass, testMethod, notifier, settings);
    }

    public static void revert() throws Exception {
        TestServerContext.get().state.revert();
    }

    static void invokeTest(TestClass testClass, TestMethod testMethod, RunNotifier notifier, Description description) {
        try {
            Object test = testClass.getConstructor().newInstance(new Object[0]);
            Field field = testClass.getJavaClass().getDeclaredField("ldapService");
            field.set(testClass.getJavaClass(), TestServerContext.get().getLdapServer());
            new MethodRoadie(test, testMethod, notifier, description).run();
        }
        catch (InvocationTargetException e) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), e.getCause());
            notifier.testAborted(description, e.getCause());
            return;
        }
        catch (InstantiationException ie) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)ie);
            notifier.testAborted(description, (Throwable)ie);
            return;
        }
        catch (IllegalAccessException iae) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)iae);
            notifier.testAborted(description, (Throwable)iae);
            return;
        }
        catch (NoSuchMethodException nsme) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)nsme);
            notifier.testAborted(description, (Throwable)nsme);
            return;
        }
        catch (NoSuchFieldException nsfe) {
            LOG.error("Failed to invoke test method: " + description.getDisplayName(), (Throwable)nsfe);
            notifier.testAborted(description, (Throwable)nsfe);
            return;
        }
    }

    void setState(TestServerState state) {
        this.state = state;
    }

    TestServerState getState() {
        return this.state;
    }

    TestServerState getNonExistentState() {
        return this.nonExistentState;
    }

    TestServerState getStartedPristineState() {
        return this.startedPristineState;
    }

    TestServerState getStartedNormalState() {
        return this.startedNormalState;
    }

    LdapService getLdapServer() {
        return this.ldapService;
    }

    void setLdapServer(LdapService ldapService) {
        this.ldapService = ldapService;
    }
}

