/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ;

import java.lang.reflect.Method;
import org.apache.directory.server.core.integ.Level;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.SiSuite;
import org.apache.directory.server.integ.state.TestServerContext;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiRunner
extends JUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SiRunner.class);
    private SiSuite suite;
    private InheritableServerSettings settings;

    public SiRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected InheritableServerSettings getSettings() {
        if (this.settings != null) {
            return this.settings;
        }
        if (this.suite == null) {
            this.settings = new InheritableServerSettings(this.getDescription(), null);
        }
        return this.settings;
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        Level cleanupLevel = this.getSettings().getCleanupLevel();
        if (cleanupLevel == Level.CLASS) {
            try {
                TestServerContext.shutdown();
                TestServerContext.cleanup();
                TestServerContext.destroy();
            }
            catch (Exception e) {
                LOG.error("Encountered exception while trying to cleanup after test class: " + this.getDescription().getDisplayName(), (Throwable)e);
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            }
        }
    }

    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        LOG.debug("About to invoke test method {}", (Object)method.getName());
        Description description = this.methodDescription(method);
        TestServerContext.test(this.getTestClass(), this.wrapMethod(method), notifier, new InheritableServerSettings(description, this.getSettings()));
        Level cleanupLevel = this.getSettings().getCleanupLevel();
        if (cleanupLevel == Level.METHOD) {
            try {
                TestServerContext.shutdown();
                TestServerContext.cleanup();
                TestServerContext.destroy();
            }
            catch (Exception e) {
                LOG.error("Encountered exception while trying to cleanup after test class: " + this.getDescription().getDisplayName(), (Throwable)e);
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            }
        }
    }

    public void setSuite(SiSuite suite) {
        this.suite = suite;
        this.settings = new InheritableServerSettings(this.getDescription(), suite.getSettings());
    }

    public SiSuite getSuite() {
        return this.suite;
    }
}

