/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.AuthenticatorBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.PasswordPolicyBean;

public class AuthenticationInterceptorBean
extends InterceptorBean {
    @ConfigurationElement(objectClass="ads-authenticator", container="authenticators")
    private List<AuthenticatorBean> authenticators = new ArrayList<AuthenticatorBean>();
    @ConfigurationElement(objectClass="ads-passwordPolicy", container="passwordPolicies")
    private List<PasswordPolicyBean> passwordPolicies = new ArrayList<PasswordPolicyBean>();

    public void setAuthenticators(List<AuthenticatorBean> authenticators) {
        this.authenticators = authenticators;
    }

    public void addAuthenticators(AuthenticatorBean ... authenticators) {
        for (AuthenticatorBean authenticator : authenticators) {
            this.authenticators.add(authenticator);
        }
    }

    public List<AuthenticatorBean> getAuthenticators() {
        return this.authenticators;
    }

    public List<PasswordPolicyBean> getPasswordPolicies() {
        return this.passwordPolicies;
    }

    public void setPasswordPolicies(List<PasswordPolicyBean> passwordPolicies) {
        this.passwordPolicies = passwordPolicies;
    }

    public void addPasswordPolicies(PasswordPolicyBean ... ppolicies) {
        for (PasswordPolicyBean ppolicy : ppolicies) {
            this.passwordPolicies.add(ppolicy);
        }
    }

    public void removePasswordPolicies(PasswordPolicyBean ... ppolicies) {
        for (PasswordPolicyBean ppolicy : ppolicies) {
            this.passwordPolicies.remove(ppolicy);
        }
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("AuthenticationInterceptor :\n");
        sb.append(super.toString(tabs + "  "));
        if (this.authenticators != null && !this.authenticators.isEmpty()) {
            sb.append(tabs).append("  authenticator :\n");
            for (AuthenticatorBean authenticator : this.authenticators) {
                sb.append(authenticator.toString(tabs + "    "));
            }
        }
        if (this.passwordPolicies != null && !this.passwordPolicies.isEmpty()) {
            for (PasswordPolicyBean ppolicy : this.passwordPolicies) {
                sb.append(ppolicy.toString("    "));
            }
        }
        return sb.toString();
    }
}

