/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import org.apache.directory.server.schema.DnNormalizer;
import org.apache.directory.server.schema.bootstrap.AbstractBootstrapProducer;
import org.apache.directory.server.schema.bootstrap.ProducerCallback;
import org.apache.directory.server.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.CachingNormalizer;
import org.apache.directory.shared.ldap.schema.DeepTrimNormalizer;
import org.apache.directory.shared.ldap.schema.DeepTrimToLowerNormalizer;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectIdentifierNormalizer;

public class SystemNormalizerProducer
extends AbstractBootstrapProducer {
    public SystemNormalizerProducer() {
        super(ProducerTypeEnum.NORMALIZER_PRODUCER);
    }

    public void produce(Registries registries, ProducerCallback cb) throws NamingException {
        CachingNormalizer normalizer = new CachingDnNormalizer();
        normalizer.setRegistries(registries);
        cb.schemaObjectProduced(this, "2.5.13.1", normalizer);
        normalizer = new CachingDeepTrimToLowerNormalizer();
        cb.schemaObjectProduced(this, "1.3.6.1.4.1.1466.109.114.2", normalizer);
        normalizer = new CachingDeepTrimToLowerNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.11", normalizer);
        normalizer = new CachingDeepTrimToLowerNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.2", normalizer);
        normalizer = new CachingDeepTrimToLowerNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.3", normalizer);
        normalizer = new CachingDeepTrimToLowerNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.4", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.6", normalizer);
        normalizer = new ObjectIdentifierNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.0", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.8", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.10", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.14", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.15", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.16", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.17", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.18", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.20", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.21", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.22", normalizer);
        normalizer = new CachingDeepTrimNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.23", normalizer);
        normalizer = new CachingDeepTrimNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.24", normalizer);
        normalizer = new CachingDeepTrimNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.27", normalizer);
        normalizer = new CachingDeepTrimNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.28", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.29", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.30", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.31", normalizer);
        normalizer = new CachingDeepTrimNormalizer();
        cb.schemaObjectProduced(this, "1.3.6.1.4.1.1466.109.114.1", normalizer);
        normalizer = new NoOpNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.13", normalizer);
        normalizer = new CachingDeepTrimNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.5", normalizer);
        normalizer = new CachingDeepTrimNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.7", normalizer);
        normalizer = new CachingDeepTrimToLowerNormalizer();
        cb.schemaObjectProduced(this, "2.5.13.12", normalizer);
        normalizer = new CachingDeepTrimToLowerNormalizer();
        cb.schemaObjectProduced(this, "1.3.6.1.4.1.1466.109.114.3", normalizer);
    }

    public static class CachingDnNormalizer
    extends CachingNormalizer {
        private static final long serialVersionUID = 1L;
        private static final Class[] parameterTypes = new Class[]{Registries.class};

        public CachingDnNormalizer() {
            super((Normalizer)new DnNormalizer());
        }

        public void setRegistries(Registries registries) throws NamingException {
            this.injectRegistries(this.normalizer, registries);
        }

        private void injectRegistries(Object obj, Registries registries) throws NamingException {
            String className = obj.getClass().getName();
            try {
                Method method = obj.getClass().getMethod("setRegistries", parameterTypes);
                if (method == null) {
                    return;
                }
                Object[] args = new Object[]{registries};
                method.invoke(obj, args);
            }
            catch (SecurityException e) {
                NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
                ne.setRootCause(e);
                throw ne;
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
                NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
                ne.setRootCause(e);
                throw ne;
            }
            catch (IllegalAccessException e) {
                NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
                ne.setRootCause(e);
                throw ne;
            }
            catch (InvocationTargetException e) {
                NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    public static class CachingDeepTrimNormalizer
    extends CachingNormalizer {
        private static final long serialVersionUID = 1L;

        public CachingDeepTrimNormalizer() {
            super((Normalizer)new DeepTrimNormalizer());
        }
    }

    public static class CachingDeepTrimToLowerNormalizer
    extends CachingNormalizer {
        private static final long serialVersionUID = 1L;

        public CachingDeepTrimToLowerNormalizer() {
            super((Normalizer)new DeepTrimToLowerNormalizer());
        }
    }
}

