/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.protocol.shared.LdapLoader;
import org.apache.directory.server.protocol.shared.LoadStrategy;
import org.apache.directory.server.protocol.shared.PropsLoader;

public abstract class ServiceConfiguration
extends Configuration {
    public static final String IP_PORT_KEY = "ipPort";
    public static final String IP_ADDRESS_KEY = "ipAddress";
    public static final String CATALOG_BASEDN_KEY = "catalogBaseDn";
    public static final String ENTRY_BASEDN_KEY = "entryBaseDn";
    public static final String INITIAL_CONTEXT_FACTORY_KEY = "initialContextFactory";
    public static final String APACHE_SERVICE_PID_KEY = "apacheServicePid";
    public static final String APACHE_FACTORY_PID_KEY = "apacheServiceFactoryPid";
    public static final String BUFFER_SIZE_KEY = "buffer.size";
    public static final String DEFAULT_ENTRY_BASEDN = "dc=example,dc=com";
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "org.apache.directory.server.core.jndi.CoreContextFactory";
    public static final String APACHE_SERVICE_CONFIGURATION = "apacheServiceConfiguration";
    public static final String SERVICE_PID = "service.pid";
    public static final String SERVICE_FACTORYPID = "service.factoryPid";
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int MINUTE = 60000;
    protected Map configuration = new HashMap();

    public String getCatalogBaseDn() {
        String key = CATALOG_BASEDN_KEY;
        if (this.configuration.containsKey(key)) {
            return this.get(key);
        }
        return null;
    }

    public String getEntryBaseDn() {
        String key = ENTRY_BASEDN_KEY;
        if (this.configuration.containsKey(key)) {
            return this.get(key);
        }
        return DEFAULT_ENTRY_BASEDN;
    }

    public String getInitialContextFactory() {
        String key = INITIAL_CONTEXT_FACTORY_KEY;
        if (this.configuration.containsKey(key)) {
            return this.get(key);
        }
        return DEFAULT_INITIAL_CONTEXT_FACTORY;
    }

    public Hashtable toJndiEnvironment() {
        Hashtable<String, ServiceConfiguration> env = new Hashtable<String, ServiceConfiguration>();
        env.put(JNDI_KEY, this);
        env.putAll(this.configuration);
        return env;
    }

    protected void loadProperties(String prefix, Map properties, int strategy) {
        LoadStrategy loader;
        switch (strategy) {
            case 1: {
                loader = new LdapLoader();
                break;
            }
            default: {
                loader = new PropsLoader();
            }
        }
        this.configuration.putAll(loader.load(prefix, properties));
    }

    protected String get(String key) {
        return (String)this.configuration.get(key);
    }
}

