/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.store;

import java.io.File;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5KdcEntryFilter
implements LdifLoadFilter {
    private static final Logger log = LoggerFactory.getLogger((Class)Krb5KdcEntryFilter.class);
    private static final String KEY_TYPE = "DES";
    private static final String OBJECTCLASS_ATTR = "objectClass";
    private static final String KRB5KDCENTRY_OC = "krb5KDCEntry";
    private static final String PASSWORD_ATTR = "userPassword";

    public boolean filter(File file, String dn, Attributes entry, DirContext ctx) throws NamingException {
        if (entry.get(OBJECTCLASS_ATTR).contains(KRB5KDCENTRY_OC)) {
            String krbPrincipal = null;
            try {
                String pw = (String)entry.get(PASSWORD_ATTR).get();
                krbPrincipal = (String)entry.get("krb5PrincipalName").get();
                KerberosPrincipal principal = new KerberosPrincipal(krbPrincipal);
                KerberosKey key = new KerberosKey(principal, pw.toCharArray(), KEY_TYPE);
                byte[] encodedKey = key.getEncoded();
                entry.put("krb5Key", encodedKey);
                entry.put("krb5KeyVersionNumber", Integer.toString(key.getVersionNumber()));
                entry.put("krb5EncryptionType", Integer.toString(key.getKeyType()));
            }
            catch (Exception e) {
                log.warn("failed to generate kerberos key\n\tkrbPrincipal=" + krbPrincipal + "\n\tdn=" + dn + "\n\tentry=\n" + entry);
            }
        }
        return true;
    }
}

