/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import javax.security.sasl.SaslServer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.shared.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.Request;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMechanismHandler
implements MechanismHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMechanismHandler.class);

    @Override
    public SaslServer handleMechanism(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setDn(bindRequest.getName());
        bindContext.setCredentials(bindRequest.getCredentials());
        bindContext.setInterceptors(ldapSession.getLdapServer().getDirectoryService().getInterceptors(OperationEnum.BIND));
        LdapProtocolUtils.setRequestControls((OperationContext)bindContext, (Request)bindRequest);
        try {
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            adminSession.getDirectoryService().getOperationManager().bind(bindContext);
            ldapSession.setCoreSession(bindContext.getSession());
            BindResponse response = (BindResponse)bindRequest.getResultResponse();
            response.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
            LdapProtocolUtils.setResponseControls((OperationContext)bindContext, (Response)response);
            ldapSession.getIoSession().write((Object)response);
            LOG.debug("Returned SUCCESS message: {}.", (Object)response);
        }
        catch (LdapException e) {
            ResultCodeEnum code = null;
            LdapResult result = ((BindResponse)bindRequest.getResultResponse()).getLdapResult();
            if (e instanceof LdapOperationException) {
                code = ((LdapOperationException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getLocalizedMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            Dn name = null;
            if (e instanceof LdapAuthenticationException) {
                name = ((LdapAuthenticationException)e).getResolvedDn();
            }
            if (name != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn(name);
            }
            result.setDiagnosticMessage(msg);
            ldapSession.getIoSession().write((Object)bindRequest.getResultResponse());
        }
        return null;
    }

    @Override
    public void init(LdapSession ldapSession) {
    }

    @Override
    public void cleanup(LdapSession ldapSession) {
        ldapSession.clearSaslProperties();
    }
}

