/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.startTls.StartTlsResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartTlsHandler
implements ExtendedOperationHandler<ExtendedRequest, ExtendedResponse> {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20037";
    private static final Set<String> EXTENSION_OIDS;
    private static final Logger LOG;
    private SSLContext sslContext;
    private List<String> cipherSuites;

    @Override
    public void handleExtendedOperation(LdapSession session, ExtendedRequest req) throws Exception {
        LOG.info("Handling StartTLS request.");
        IoFilterChain chain = session.getIoSession().getFilterChain();
        SslFilter sslFilter = (SslFilter)chain.get("sslFilter");
        if (sslFilter == null) {
            sslFilter = new SslFilter(this.sslContext);
            if (this.cipherSuites != null && !this.cipherSuites.isEmpty()) {
                sslFilter.setEnabledCipherSuites(this.cipherSuites.toArray(new String[this.cipherSuites.size()]));
            }
            chain.addFirst("sslFilter", (IoFilter)sslFilter);
        } else {
            sslFilter.startSsl(session.getIoSession());
        }
        ExtendedResponseDecorator res = new ExtendedResponseDecorator(LdapApiServiceFactory.getSingleton(), (ExtendedResponse)new StartTlsResponseImpl(req.getMessageId()));
        LdapResult result = res.getLdapResult();
        result.setResultCode(ResultCodeEnum.SUCCESS);
        res.setResponseName(EXTENSION_OID);
        res.setResponseValue(Strings.EMPTY_BYTES);
        session.getIoSession().setAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE);
        session.getIoSession().write((Object)res);
    }

    @Override
    public final Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public final String getOid() {
        return EXTENSION_OID;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
        LOG.debug("Setting LDAP Service");
        Provider provider = Security.getProvider("SUN");
        LOG.debug("provider = {}", (Object)provider);
        try {
            this.sslContext = SSLContext.getInstance("TLS");
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err((I18n)I18n.ERR_681, (Object[])new Object[0]), e);
        }
        try {
            this.sslContext.init(ldapServer.getKeyManagerFactory().getKeyManagers(), new TrustManager[]{new NoVerificationTrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err((I18n)I18n.ERR_682, (Object[])new Object[0]), e);
        }
        this.cipherSuites = ldapServer.getEnabledCipherSuites();
    }

    static {
        LOG = LoggerFactory.getLogger(StartTlsHandler.class);
        HashSet<String> set = new HashSet<String>(3);
        set.add(EXTENSION_OID);
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

