/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.gssapi;

import java.util.Hashtable;
import javax.naming.ldap.LdapContext;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslCallbackHandler;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GssapiCallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GssapiCallbackHandler.class);
    private LdapSession ldapSession;

    public GssapiCallbackHandler(DirectoryService directoryService, LdapSession ldapSession, BindRequest bindRequest) {
        super(directoryService, bindRequest);
        this.ldapSession = ldapSession;
    }

    protected EntryAttribute lookupPassword(String username, String password) {
        return null;
    }

    protected void authorize(AuthorizeCallback authorizeCB) throws Exception {
        LOG.debug("Processing conversion of principal name to DN.");
        Hashtable<String, Object> env = this.getEnvironment(this.ldapSession.getIoSession());
        LdapContext ctx = this.getContext(this.ldapSession.getIoSession(), this.bindRequest, env);
        String username = authorizeCB.getAuthorizationID();
        GetPrincipal getPrincipal = new GetPrincipal(new KerberosPrincipal(username));
        PrincipalStoreEntry entry = (PrincipalStoreEntry)getPrincipal.execute(this.ldapSession.getCoreSession(), new LdapDN());
        String bindDn = entry.getDistinguishedName();
        LOG.debug("Converted username {} to DN {}.", (Object)username, (Object)bindDn);
        this.ldapSession.getIoSession().setAttribute("java.naming.security.principal", (Object)bindDn);
        authorizeCB.setAuthorizedID(bindDn);
        authorizeCB.setAuthorized(true);
    }
}

