/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.SaslFilter;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMechanismHandler
implements MechanismHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMechanismHandler.class);

    protected void insertSaslFilter(LdapSession ldapSession) {
        LOG.debug("Inserting SaslFilter to engage negotiated security layer.");
        IoSession ioSession = ldapSession.getIoSession();
        IoFilterChain chain = ioSession.getFilterChain();
        if (!chain.contains("SASL_FILTER")) {
            SaslServer saslServer = (SaslServer)ldapSession.getSaslProperty("saslServer");
            chain.addBefore("codec", "SASL_FILTER", (IoFilter)new SaslFilter(saslServer));
        }
        ioSession.setAttribute(SaslFilter.DISABLE_SECURITY_LAYER_ONCE, (Object)Boolean.TRUE);
    }
}

