/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.ReferralAwareRequestHandler;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDnHandler
extends ReferralAwareRequestHandler<ModifyDnRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDnHandler.class);

    @Override
    public void handleIgnoringReferrals(LdapSession session, LdapDN reqTargetDn, ClonedServerEntry entry, ModifyDnRequest req) {
        LdapResult result = req.getResultResponse().getLdapResult();
        LOG.debug("Handling modify dn request while ignoring referrals: {}", (Object)req);
        if (req.getName().isEmpty()) {
            String msg = "Modify DN is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setErrorMessage(msg);
            session.getIoSession().write((Object)req.getResultResponse());
            return;
        }
        try {
            boolean rdnChanged;
            LdapDN newRdn = new LdapDN(req.getNewRdn().toString());
            newRdn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            LdapDN oldRdn = new LdapDN(req.getName().getRdn().toString());
            oldRdn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            boolean bl = rdnChanged = req.getNewRdn() != null && !newRdn.getNormName().equals(oldRdn.getNormName());
            if (rdnChanged) {
                if (req.getNewSuperior() != null) {
                    session.getCoreSession().moveAndRename(req);
                } else {
                    session.getCoreSession().rename(req);
                }
            } else if (req.getNewSuperior() != null) {
                req.setNewRdn(null);
                session.getCoreSession().move(req);
            } else {
                result.setErrorMessage("Attempt to move entry onto itself.");
                result.setResultCode(ResultCodeEnum.ENTRY_ALREADY_EXISTS);
                result.setMatchedDn(req.getName());
                session.getIoSession().write((Object)req.getResultResponse());
                return;
            }
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write((Object)req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

