/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Collections;
import java.util.HashSet;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamingListener;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.support.PersistentSearchListener;
import org.apache.directory.server.ldap.support.SearchHandler;
import org.apache.directory.server.ldap.support.SearchResponseIterator;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.PersistentSearchControl;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.directory.shared.ldap.message.Response;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.ScopeEnum;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.SearchResponseDone;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchHandler
extends SearchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SearchHandler.class);
    private static final String DEREFALIASES_KEY = "java.naming.ldap.derefAliases";
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    private SearchControls getSearchControls(SearchRequest req, String[] ids, boolean isAdmin, int maxSize, int maxTime) {
        SearchControls controls = new SearchControls();
        if (isAdmin) {
            controls.setCountLimit(req.getSizeLimit());
            int timeLimit = req.getTimeLimit();
            if (timeLimit > 2147483) {
                timeLimit = 0;
            }
            controls.setTimeLimit(timeLimit * 1000);
        } else {
            controls.setCountLimit(Math.min(req.getSizeLimit(), maxSize));
            controls.setTimeLimit(Math.min(req.getTimeLimit(), maxTime));
        }
        controls.setSearchScope(req.getScope().getValue());
        controls.setReturningObjFlag(req.getTypesOnly());
        controls.setReturningAttributes(ids);
        controls.setDerefLinkFlag(true);
        return controls;
    }

    private static boolean isRootDSESearch(SearchRequest req) {
        boolean isBaseIsRoot = req.getBase().isEmpty();
        boolean isBaseScope = req.getScope() == ScopeEnum.BASE_OBJECT;
        boolean isRootDSEFilter = false;
        if (req.getFilter() instanceof PresenceNode) {
            isRootDSEFilter = ((PresenceNode)req.getFilter()).getAttribute().equalsIgnoreCase("objectClass");
        }
        return isBaseIsRoot && isBaseScope && isRootDSEFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchMessageReceived(IoSession session, SearchRequest req) throws Exception {
        LdapServer ldapServer = (LdapServer)((Object)session.getAttribute(LdapServer.class.toString()));
        if (IS_DEBUG) {
            LOG.debug("Message received:  {}", (Object)req.toString());
        }
        NamingEnumeration list = null;
        String[] ids = null;
        HashSet<String> retAttrs = new HashSet<String>();
        retAttrs.addAll(req.getAttributes());
        this.getSessionRegistry().addOutstandingRequest(session, (Request)req);
        if (retAttrs.size() > 0 && !retAttrs.contains("ref")) {
            retAttrs.add("ref");
            ids = retAttrs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        } else if (retAttrs.size() > 0) {
            ids = retAttrs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
        try {
            LdapContext unknown;
            boolean isRootDSESearch = DefaultSearchHandler.isRootDSESearch(req);
            ServerLdapContext ctx = isRootDSESearch ? (!((unknown = this.getSessionRegistry().getLdapContextOnRootDSEAccess(session, null)) instanceof ServerLdapContext) ? (ServerLdapContext)unknown.lookup("") : (ServerLdapContext)unknown) : (!((unknown = this.getSessionRegistry().getLdapContext(session, null, true)) instanceof ServerLdapContext) ? (ServerLdapContext)unknown.lookup("") : (ServerLdapContext)unknown);
            this.setRequestControls((LdapContext)ctx, (Message)req);
            ctx.addToEnvironment(DEREFALIASES_KEY, (Object)req.getDerefAliases().getJndiValue());
            if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                ctx.addToEnvironment("java.naming.referral", (Object)"ignore");
            } else {
                ctx.addToEnvironment("java.naming.referral", (Object)"throw-finding-base");
            }
            boolean allowAnonymousBinds = ldapServer.isAllowAnonymousAccess();
            boolean isAnonymousUser = ctx.getPrincipal().getName().trim().equals("");
            if (isAnonymousUser && !allowAnonymousBinds && !isRootDSESearch) {
                LdapResult result = req.getResultResponse().getLdapResult();
                result.setResultCode(ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS);
                String msg = "Bind failure: Anonymous binds have been disabled!";
                result.setErrorMessage(msg);
                session.write((Object)req.getResultResponse());
                return;
            }
            int maxSize = ldapServer.getMaxSizeLimit();
            int maxTime = ldapServer.getMaxTimeLimit();
            SearchControls controls = isAnonymousUser ? this.getSearchControls(req, ids, false, maxSize, maxTime) : (ctx.getPrincipal().getName().trim().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system") ? this.getSearchControls(req, ids, true, maxSize, maxTime) : this.getSearchControls(req, ids, false, maxSize, maxTime));
            PersistentSearchControl psearchControl = (PersistentSearchControl)req.getControls().get("2.16.840.1.113730.3.4.3");
            if (psearchControl != null) {
                controls.setCountLimit(0L);
                controls.setTimeLimit(0);
                if (!psearchControl.isChangesOnly()) {
                    list = ctx.search((Name)req.getBase(), req.getFilter(), controls);
                    if (list instanceof AbandonListener) {
                        req.addAbandonListener((AbandonListener)list);
                    }
                    if (list.hasMore()) {
                        SearchResponseIterator it = new SearchResponseIterator(req, ctx, list, controls.getSearchScope(), session, this.getSessionRegistry());
                        while (it.hasNext()) {
                            Response resp = (Response)it.next();
                            if (resp instanceof SearchResponseDone) {
                                ResultCodeEnum rcode = ((SearchResponseDone)resp).getLdapResult().getResultCode();
                                if (rcode == ResultCodeEnum.SUCCESS) break;
                                session.write((Object)resp);
                                return;
                            }
                            session.write((Object)resp);
                        }
                    }
                }
                PersistentSearchListener handler = new PersistentSearchListener(this.getSessionRegistry(), ctx, session, req);
                ctx.addNamingListener((Name)req.getBase(), req.getFilter().toString(), controls, (NamingListener)handler);
                return;
            }
            list = ctx.search((Name)req.getBase(), req.getFilter(), controls);
            if (list instanceof AbandonListener) {
                req.addAbandonListener((AbandonListener)list);
            }
            if (list.hasMore()) {
                SearchResponseIterator it = new SearchResponseIterator(req, ctx, list, controls.getSearchScope(), session, this.getSessionRegistry());
                while (it.hasNext()) {
                    session.write(it.next());
                }
            } else {
                list.close();
                req.getResultResponse().getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
                for (ResultResponse resultResponse : Collections.singleton(req.getResultResponse())) {
                    session.write((Object)resultResponse);
                }
            }
        }
        catch (ReferralException e) {
            LdapResult result = req.getResultResponse().getLdapResult();
            ReferralImpl refs = new ReferralImpl();
            result.setReferral((Referral)refs);
            result.setResultCode(ResultCodeEnum.REFERRAL);
            result.setErrorMessage("Encountered referral attempting to handle add request.");
            do {
                refs.addLdapUrl((String)e.getReferralInfo());
            } while (e.skipReferral());
            session.write((Object)req.getResultResponse());
            this.getSessionRegistry().removeOutstandingRequest(session, req.getMessageId());
        }
        catch (NamingException e) {
            if (e instanceof OperationAbandonedException) {
                return;
            }
            String msg = "failed on search operation: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + req + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(code);
            result.setErrorMessage(msg);
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            for (ResultResponse resultResponse : Collections.singleton(req.getResultResponse())) {
                session.write((Object)resultResponse);
            }
            this.getSessionRegistry().removeOutstandingRequest(session, req.getMessageId());
        }
        finally {
            if (list != null) {
                try {
                    list.close();
                }
                catch (NamingException e) {
                    LOG.error("failed on list.close()", (Throwable)e);
                }
            }
        }
    }
}

