/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.support.ExtendedHandler;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;

public class DefaultExtendedHandler
extends ExtendedHandler {
    public void extendedMessageReceived(IoSession session, ExtendedRequest req) throws Exception {
        ExtendedOperationHandler handler = this.getHandler(req.getOid());
        if (handler == null) {
            String msg = "Unrecognized extended operation EXTENSION_OID: " + req.getOid();
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setErrorMessage(msg);
            session.write((Object)req.getResultResponse());
        } else {
            try {
                handler.handleExtendedOperation(session, this.getSessionRegistry(), req);
            }
            catch (Exception e) {
                LdapResult result = req.getResultResponse().getLdapResult();
                result.setResultCode(ResultCodeEnum.OTHER);
                result.setErrorMessage("Extended operation handler for the specified EXTENSION_OID (" + req.getOid() + ") has failed to process your request:\n" + ExceptionUtils.getStackTrace((Throwable)e));
                ExtendedResponse resp = (ExtendedResponse)req.getResultResponse();
                resp.setResponse(new byte[0]);
                session.write((Object)req.getResultResponse());
            }
        }
    }
}

