/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import org.apache.directory.server.ldap.support.AbandonHandler;
import org.apache.directory.shared.ldap.message.AbandonRequest;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAbandonHandler
extends AbandonHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbandonHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public void abandonMessageReceived(IoSession session, AbandonRequest req) throws Exception {
        int abandonedId = req.getAbandoned();
        if (abandonedId < 0) {
            return;
        }
        Request abandonedRequest = this.getSessionRegistry().getOutstandingRequest(session, abandonedId);
        if (abandonedRequest == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Got abandon request from client " + session + " but request must have already " + "terminated.  Abandon request " + req + " had no effect.");
            }
            return;
        }
        if (abandonedRequest instanceof AbandonableRequest) {
            LOG.warn("Abandon, Bind, Unbind, and StartTLS operations cannot be abandoned.  Abandon request will be ignored.");
        }
        ((AbandonableRequest)abandonedRequest).abandon();
        if (this.getSessionRegistry().removeOutstandingRequest(session, abandonedId) == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Got abandon request from client " + session + " but request must have already " + "terminated.");
            }
        } else if (IS_DEBUG) {
            LOG.debug("Abandoned request:  ", (Object)req);
        }
    }
}

