/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.support.bind.SaslFilter;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnSuccess
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(ReturnSuccess.class);
    private static final String SASL_CONTEXT = "saslContext";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        BindRequest request = (BindRequest)message;
        LdapResult result = request.getResultResponse().getLdapResult();
        byte[] tokenBytes = (byte[])session.getAttribute("saslCreds");
        result.setResultCode(ResultCodeEnum.SUCCESS);
        BindResponse response = (BindResponse)request.getResultResponse();
        response.setServerSaslCreds(tokenBytes);
        String sessionMechanism = (String)session.getAttribute("sessionMechanism");
        if (sessionMechanism.equals("DIGEST-MD5") || sessionMechanism.equals("GSSAPI")) {
            log.debug("Inserting SaslFilter to engage negotiated security layer.");
            IoFilterChain chain = session.getFilterChain();
            if (!chain.contains("SASL")) {
                SaslServer saslContext = (SaslServer)session.getAttribute(SASL_CONTEXT);
                chain.addBefore("codec", "SASL", (IoFilter)new SaslFilter(saslContext));
            }
            session.setAttribute(SaslFilter.DISABLE_SECURITY_LAYER_ONCE, (Object)Boolean.TRUE);
        }
        session.write((Object)response);
        log.debug("Returned SUCCESS message.");
        next.execute(session, message);
    }
}

