/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Hashtable;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.support.bind.AbstractSaslCallbackHandler;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GssapiCallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(GssapiCallbackHandler.class);
    private IoSession session;
    private Object message;

    public GssapiCallbackHandler(IoSession session, Object message) {
        this.session = session;
        this.message = message;
    }

    protected String lookupPassword(String username, String password) {
        return null;
    }

    protected void authorize(AuthorizeCallback authorizeCB) {
        log.debug("Processing conversion of principal name to DN.");
        Hashtable<String, Object> env = this.getEnvironment(this.session);
        LdapContext ctx = this.getContext(this.session, this.message, env);
        String username = authorizeCB.getAuthorizationID();
        GetPrincipal getPrincipal = new GetPrincipal(new KerberosPrincipal(username));
        PrincipalStoreEntry entry = (PrincipalStoreEntry)getPrincipal.execute((DirContext)ctx, null);
        String bindDn = entry.getDistinguishedName();
        log.debug("Converted username {} to DN {}.", (Object)username, (Object)bindDn);
        this.session.setAttribute("java.naming.security.principal", (Object)bindDn);
        authorizeCB.setAuthorizedID(bindDn);
        authorizeCB.setAuthorized(true);
    }
}

