/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.LdapMessageHandler;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnbindHandler
implements LdapMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(UnbindHandler.class);

    public void messageReceived(IoSession session, Object request) throws Exception {
        SessionRegistry registry = SessionRegistry.getSingleton();
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, false);
            if (ctx != null) {
                if (ctx instanceof ServerLdapContext && ((ServerLdapContext)ctx).getService().isStarted()) {
                    ((ServerLdapContext)ctx).ldapUnbind();
                }
                ctx.close();
            }
            registry.terminateSession(session);
            registry.remove(session);
        }
        catch (NamingException e) {
            log.error("failed to unbind session properly", (Throwable)e);
        }
    }

    public void init(StartupConfiguration cfg) {
    }
}

