/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.LdapMessageHandler;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyHandler
implements LdapMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(ModifyHandler.class);
    private static final ModificationItemImpl[] EMPTY = new ModificationItemImpl[0];
    private static Control[] EMPTY_CONTROLS = new Control[0];
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public void messageReceived(IoSession session, Object request) throws Exception {
        ModifyRequest req = (ModifyRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                ctx.addToEnvironment("java.naming.referral", "ignore");
            } else {
                ctx.addToEnvironment("java.naming.referral", "throw");
            }
            ctx.setRequestControls((javax.naming.ldap.Control[])req.getControls().values().toArray(EMPTY_CONTROLS));
            ModificationItemImpl[] mods = req.getModificationItems().toArray(EMPTY);
            ctx.modifyAttributes((Name)req.getName(), (ModificationItem[])mods);
        }
        catch (ReferralException e) {
            ReferralImpl refs = new ReferralImpl();
            result.setReferral((Referral)refs);
            result.setResultCode(ResultCodeEnum.REFERRAL);
            result.setErrorMessage("Encountered referral attempting to handle modify request.");
            do {
                refs.addLdapUrl((String)e.getReferralInfo());
            } while (e.skipReferral());
            session.write((Object)req.getResultResponse());
            return;
        }
        catch (NamingException e) {
            String msg = "failed to modify entry " + req.getName() + ": " + e.getMessage();
            if (IS_DEBUG) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            result.setResultCode(code);
            result.setErrorMessage(msg);
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            session.write((Object)req.getResultResponse());
            return;
        }
        result.setResultCode(ResultCodeEnum.SUCCESS);
        session.write((Object)req.getResultResponse());
    }

    public void init(StartupConfiguration cfg) {
    }
}

