/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.SearchHandler;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.EntryChangeControl;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.PersistentSearchControl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistentSearchListener
implements ObjectChangeListener,
NamespaceChangeListener,
AbandonListener {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchHandler.class);
    final ServerLdapContext ctx;
    final IoSession session;
    final SearchRequest req;
    final PersistentSearchControl control;

    PersistentSearchListener(ServerLdapContext ctx, IoSession session, SearchRequest req) {
        this.session = session;
        this.req = req;
        req.addAbandonListener((AbandonListener)this);
        this.ctx = ctx;
        this.control = (PersistentSearchControl)req.getControls().get("2.16.840.1.113730.3.4.3");
    }

    public void abandon() throws NamingException {
        this.ctx.removeNamingListener((NamingListener)this);
    }

    public void namingExceptionThrown(NamingExceptionEvent evt) {
        try {
            this.ctx.removeNamingListener((NamingListener)this);
        }
        catch (NamingException e) {
            log.error("Attempt to remove listener from context failed", (Throwable)e);
        }
        if (evt.getException() instanceof OperationAbandonedException) {
            return;
        }
        SessionRegistry.getSingleton().removeOutstandingRequest(this.session, new Integer(this.req.getMessageId()));
        String msg = "failed on persistent search operation";
        if (log.isDebugEnabled()) {
            msg = msg + ":\n" + this.req + ":\n" + ExceptionUtils.getStackTrace((Throwable)evt.getException());
        }
        ResultCodeEnum code = null;
        code = evt.getException() instanceof LdapException ? ((LdapException)evt.getException()).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)evt.getException(), (MessageTypeEnum)this.req.getType());
        LdapResult result = this.req.getResultResponse().getLdapResult();
        result.setResultCode(code);
        result.setErrorMessage(msg);
        if (evt.getException().getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
            result.setMatchedDn(evt.getException().getResolvedName().toString());
        }
        this.session.write((Object)this.req.getResultResponse());
    }

    public void objectChanged(NamingEvent evt) {
        this.sendEntry(evt);
    }

    public void objectAdded(NamingEvent evt) {
        this.sendEntry(evt);
    }

    public void objectRemoved(NamingEvent evt) {
        this.sendEntry(evt);
    }

    public void objectRenamed(NamingEvent evt) {
        this.sendEntry(evt);
    }

    private void sendEntry(NamingEvent evt) {
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(this.req.getMessageId());
        EntryChangeControl ecControl = null;
        if (this.control.isReturnECs()) {
            ecControl = new EntryChangeControl();
            respEntry.add((Control)ecControl);
        }
        switch (evt.getType()) {
            case 0: {
                if (!this.control.isNotificationEnabled(ChangeType.ADD)) {
                    return;
                }
                respEntry.setObjectName(evt.getNewBinding().getName());
                respEntry.setAttributes((Attributes)evt.getChangeInfo());
                if (ecControl == null) break;
                ecControl.setChangeType(ChangeType.ADD);
                break;
            }
            case 3: {
                if (!this.control.isNotificationEnabled(ChangeType.MODIFY)) {
                    return;
                }
                respEntry.setObjectName(evt.getOldBinding().getName());
                respEntry.setAttributes((Attributes)evt.getOldBinding().getObject());
                if (ecControl == null) break;
                ecControl.setChangeType(ChangeType.MODIFY);
                break;
            }
            case 1: {
                if (!this.control.isNotificationEnabled(ChangeType.DELETE)) {
                    return;
                }
                respEntry.setObjectName(evt.getOldBinding().getName());
                respEntry.setAttributes((Attributes)evt.getOldBinding().getObject());
                if (ecControl == null) break;
                ecControl.setChangeType(ChangeType.DELETE);
                break;
            }
            case 2: {
                if (!this.control.isNotificationEnabled(ChangeType.MODDN)) {
                    return;
                }
                respEntry.setObjectName(evt.getNewBinding().getName());
                respEntry.setAttributes((Attributes)evt.getNewBinding().getObject());
                if (ecControl == null) break;
                ecControl.setChangeType(ChangeType.MODDN);
                ecControl.setPreviousDn(evt.getOldBinding().getName());
                break;
            }
            default: {
                return;
            }
        }
        this.session.write((Object)respEntry);
    }

    public void requestAbandoned(AbandonableRequest req) {
        try {
            this.abandon();
        }
        catch (NamingException e) {
            log.error("failed to properly abandon this persistent search", (Throwable)e);
        }
    }
}

