/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.io.encoder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.dns.io.encoder.AddressRecordEncoder;
import org.apache.directory.server.dns.io.encoder.CanonicalNameRecordEncoder;
import org.apache.directory.server.dns.io.encoder.MailExchangeRecordEncoder;
import org.apache.directory.server.dns.io.encoder.NameServerRecordEncoder;
import org.apache.directory.server.dns.io.encoder.PointerRecordEncoder;
import org.apache.directory.server.dns.io.encoder.QuestionRecordEncoder;
import org.apache.directory.server.dns.io.encoder.RecordEncoder;
import org.apache.directory.server.dns.io.encoder.ResourceRecordEncoder;
import org.apache.directory.server.dns.io.encoder.ServerSelectionRecordEncoder;
import org.apache.directory.server.dns.io.encoder.StartOfAuthorityRecordEncoder;
import org.apache.directory.server.dns.io.encoder.TextRecordEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsMessageEncoder {
    private static final Logger log = LoggerFactory.getLogger(DnsMessageEncoder.class);
    private static final Map<RecordType, RecordEncoder> DEFAULT_ENCODERS;

    public void encode(IoBuffer byteBuffer, DnsMessage message) {
        byteBuffer.putShort((short)message.getTransactionId());
        byte header = 0;
        header = (byte)(header | this.encodeMessageType(message.getMessageType()));
        header = (byte)(header | this.encodeOpCode(message.getOpCode()));
        header = (byte)(header | this.encodeAuthoritativeAnswer(message.isAuthoritativeAnswer()));
        header = (byte)(header | this.encodeTruncated(message.isTruncated()));
        header = (byte)(header | this.encodeRecursionDesired(message.isRecursionDesired()));
        byteBuffer.put(header);
        header = 0;
        header = (byte)(header | this.encodeRecursionAvailable(message.isRecursionAvailable()));
        header = (byte)(header | this.encodeResponseCode(message.getResponseCode()));
        byteBuffer.put(header);
        byteBuffer.putShort((short)(message.getQuestionRecords() != null ? message.getQuestionRecords().size() : 0));
        byteBuffer.putShort((short)(message.getAnswerRecords() != null ? message.getAnswerRecords().size() : 0));
        byteBuffer.putShort((short)(message.getAuthorityRecords() != null ? message.getAuthorityRecords().size() : 0));
        byteBuffer.putShort((short)(message.getAdditionalRecords() != null ? message.getAdditionalRecords().size() : 0));
        this.putQuestionRecords(byteBuffer, message.getQuestionRecords());
        this.putResourceRecords(byteBuffer, message.getAnswerRecords());
        this.putResourceRecords(byteBuffer, message.getAuthorityRecords());
        this.putResourceRecords(byteBuffer, message.getAdditionalRecords());
    }

    private void putQuestionRecords(IoBuffer byteBuffer, List<QuestionRecord> questions) {
        if (questions == null) {
            return;
        }
        QuestionRecordEncoder encoder = new QuestionRecordEncoder();
        for (QuestionRecord question : questions) {
            encoder.put(byteBuffer, question);
        }
    }

    private void putResourceRecords(IoBuffer byteBuffer, List<ResourceRecord> records) {
        if (records == null) {
            return;
        }
        for (ResourceRecord record : records) {
            try {
                this.put(byteBuffer, record);
            }
            catch (IOException ioe) {
                log.error(ioe.getLocalizedMessage(), (Throwable)ioe);
            }
        }
    }

    private void put(IoBuffer byteBuffer, ResourceRecord record) throws IOException {
        RecordType type = record.getRecordType();
        RecordEncoder encoder = DEFAULT_ENCODERS.get(type);
        if (encoder == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_597, (Object[])new Object[]{type}));
        }
        encoder.put(byteBuffer, record);
    }

    private byte encodeMessageType(MessageType messageType) {
        byte oneBit = (byte)(messageType.convert() & 1);
        return (byte)(oneBit << 7);
    }

    private byte encodeOpCode(OpCode opCode) {
        byte fourBits = (byte)(opCode.convert() & 0xF);
        return (byte)(fourBits << 3);
    }

    private byte encodeAuthoritativeAnswer(boolean authoritative) {
        if (authoritative) {
            return 4;
        }
        return 0;
    }

    private byte encodeTruncated(boolean truncated) {
        if (truncated) {
            return 2;
        }
        return 0;
    }

    private byte encodeRecursionDesired(boolean recursionDesired) {
        if (recursionDesired) {
            return 1;
        }
        return 0;
    }

    private byte encodeRecursionAvailable(boolean recursionAvailable) {
        if (recursionAvailable) {
            return -128;
        }
        return 0;
    }

    private byte encodeResponseCode(ResponseCode responseCode) {
        return (byte)(responseCode.convert() & 0xF);
    }

    static {
        HashMap<RecordType, ResourceRecordEncoder> map = new HashMap<RecordType, ResourceRecordEncoder>();
        map.put(RecordType.SOA, new StartOfAuthorityRecordEncoder());
        map.put(RecordType.A, new AddressRecordEncoder());
        map.put(RecordType.NS, new NameServerRecordEncoder());
        map.put(RecordType.CNAME, new CanonicalNameRecordEncoder());
        map.put(RecordType.PTR, new PointerRecordEncoder());
        map.put(RecordType.MX, new MailExchangeRecordEncoder());
        map.put(RecordType.SRV, new ServerSelectionRecordEncoder());
        map.put(RecordType.TXT, new TextRecordEncoder());
        DEFAULT_ENCODERS = Collections.unmodifiableMap(map);
    }
}

