/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.protocol;

import java.util.ArrayList;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.protocol.DnsProtocolTcpCodecFactory;
import org.apache.directory.server.dns.protocol.DnsProtocolUdpCodecFactory;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.service.DomainNameService;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsProtocolHandler
implements IoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DnsProtocolHandler.class);
    private DnsServer config;
    private RecordStore store;
    private String contextKey = "context";

    public DnsProtocolHandler(DnsServer config, RecordStore store) {
        this.config = config;
        this.store = store;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} CREATED:  {}", (Object)session.getRemoteAddress(), (Object)session.getTransportMetadata());
        }
        if (session.getTransportMetadata().isConnectionless()) {
            session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)DnsProtocolUdpCodecFactory.getInstance()));
        } else {
            session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)DnsProtocolTcpCodecFactory.getInstance()));
        }
    }

    public void sessionOpened(IoSession session) {
        LOG.debug("{} OPENED", (Object)session.getRemoteAddress());
    }

    public void sessionClosed(IoSession session) {
        LOG.debug("{} CLOSED", (Object)session.getRemoteAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        LOG.debug("{} IDLE ({})", (Object)session.getRemoteAddress(), (Object)status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        LOG.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) {
        LOG.debug("{} RCVD:  {}", (Object)session.getRemoteAddress(), message);
        try {
            DnsContext dnsContext = new DnsContext();
            dnsContext.setConfig(this.config);
            dnsContext.setStore(this.store);
            session.setAttribute((Object)this.getContextKey(), (Object)dnsContext);
            DomainNameService.execute(dnsContext, (DnsMessage)message);
            DnsMessage response = dnsContext.getReply();
            session.write((Object)response);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            DnsMessage request = (DnsMessage)message;
            DnsException de = (DnsException)e;
            DnsMessageModifier modifier = new DnsMessageModifier();
            modifier.setTransactionId(request.getTransactionId());
            modifier.setMessageType(MessageType.RESPONSE);
            modifier.setOpCode(OpCode.QUERY);
            modifier.setAuthoritativeAnswer(false);
            modifier.setTruncated(false);
            modifier.setRecursionDesired(request.isRecursionDesired());
            modifier.setRecursionAvailable(false);
            modifier.setReserved(false);
            modifier.setAcceptNonAuthenticatedData(false);
            modifier.setResponseCode(ResponseCode.convert((byte)de.getResponseCode()));
            modifier.setQuestionRecords(request.getQuestionRecords());
            modifier.setAnswerRecords(new ArrayList<ResourceRecord>());
            modifier.setAuthorityRecords(new ArrayList<ResourceRecord>());
            modifier.setAdditionalRecords(new ArrayList<ResourceRecord>());
            session.write((Object)modifier.getDnsMessage());
        }
    }

    public void messageSent(IoSession session, Object message) {
        LOG.debug("{} SENT:  {}", (Object)session.getRemoteAddress(), message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

