/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.store.jndi.JndiRecordStoreImpl;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class DnsServer
extends DirectoryBackedService {
    private static final long serialVersionUID = 6943138644427163149L;
    private static final int IP_PORT_DEFAULT = 53;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.dns";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS DNS Service";

    public DnsServer() {
        super.setIpPort(53);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
    }

    public void start() throws IOException {
        JndiRecordStoreImpl store = new JndiRecordStoreImpl(this.getSearchBaseDn(), this.getSearchBaseDn(), this.getDirectoryService());
        if (this.getDatagramAcceptor() != null) {
            DatagramAcceptorConfig udpConfig = new DatagramAcceptorConfig();
            this.getDatagramAcceptor().bind((SocketAddress)new InetSocketAddress(this.getIpPort()), (IoHandler)new DnsProtocolHandler(this, store), (IoServiceConfig)udpConfig);
        }
        if (this.getSocketAcceptor() != null) {
            SocketAcceptorConfig tcpConfig = new SocketAcceptorConfig();
            tcpConfig.setDisconnectOnUnbind(false);
            tcpConfig.setReuseAddress(true);
            this.getSocketAcceptor().bind((SocketAddress)new InetSocketAddress(this.getIpPort()), (IoHandler)new DnsProtocolHandler(this, store), (IoServiceConfig)tcpConfig);
        }
    }

    public void stop() {
        if (this.getDatagramAcceptor() != null) {
            this.getDatagramAcceptor().unbind((SocketAddress)new InetSocketAddress(this.getIpPort()));
        }
        if (this.getSocketAcceptor() != null) {
            this.getSocketAcceptor().unbind((SocketAddress)new InetSocketAddress(this.getIpPort()));
        }
    }
}

