/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Set;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.dns.store.jndi.MultiBaseSearch;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.SingleBaseSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiRecordStoreImpl
implements RecordStore {
    private DnsConfiguration config;
    private InitialContextFactory factory;
    private SearchStrategy strategy;

    public JndiRecordStoreImpl(DnsConfiguration config, InitialContextFactory factory) {
        this.config = config;
        this.factory = factory;
        this.strategy = this.getSearchStrategy();
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        return this.strategy.getRecords(question);
    }

    private SearchStrategy getSearchStrategy() {
        if (this.config.getCatalogBaseDn() != null) {
            return new MultiBaseSearch(this.config, this.factory);
        }
        return new SingleBaseSearch(this.config, this.factory);
    }
}

