/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetResourceRecords
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(GetResourceRecords.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        DnsContext dnsContext = (DnsContext)session.getAttribute(this.getContextKey());
        RecordStore store = dnsContext.getStore();
        DnsMessage request = (DnsMessage)message;
        List<QuestionRecord> questions = request.getQuestionRecords();
        Iterator<QuestionRecord> it = questions.iterator();
        while (it.hasNext()) {
            dnsContext.addResourceRecords(this.getEntry(store, it.next()));
        }
        next.execute(session, message);
    }

    public Set<ResourceRecord> getEntry(RecordStore store, QuestionRecord question) throws DnsException {
        Set<ResourceRecord> records = null;
        records = store.getRecords(question);
        if (records == null || records.isEmpty()) {
            log.debug("The domain name referenced in the query does not exist.");
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        return records;
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

