/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.store.DnsCatalog;
import org.apache.directory.server.dns.store.SearchStrategy;
import org.apache.directory.server.dns.store.operations.GetRecords;
import org.apache.directory.server.protocol.shared.catalog.Catalog;
import org.apache.directory.server.protocol.shared.catalog.GetCatalog;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBaseSearch
implements SearchStrategy {
    private static final Logger log = LoggerFactory.getLogger((Class)MultiBaseSearch.class);
    private InitialContextFactory factory;
    private Hashtable env;
    private Catalog catalog;

    MultiBaseSearch(DnsConfiguration config, InitialContextFactory factory) {
        this.factory = factory;
        this.env = new Hashtable(config.toJndiEnvironment());
        this.env.put("java.naming.factory.initial", config.getInitialContextFactory());
        this.env.put("java.naming.provider.url", config.getCatalogBaseDn());
        try {
            DirContext ctx = (DirContext)factory.getInitialContext(this.env);
            this.catalog = new DnsCatalog((Map)this.execute(ctx, (ContextOperation)new GetCatalog()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String message = "Failed to get catalog context " + (String)this.env.get("java.naming.provider.url");
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    public Set getRecords(QuestionRecord question) throws Exception {
        this.env.put("java.naming.provider.url", this.catalog.getBaseDn(question.getDomainName()));
        try {
            DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
            return (Set)this.execute(ctx, new GetRecords(question));
        }
        catch (NamingException ne) {
            log.error(ne.getMessage(), (Throwable)ne);
            String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
            throw new ConfigurationException(message, (Throwable)ne);
        }
    }

    private Object execute(DirContext ctx, ContextOperation operation) throws Exception {
        return operation.execute(ctx, null);
    }
}

